/*	COPYRIGHT (c) 1989 by Novell, Inc.  All Rights Reserved.   */
#include <nwconsol.h>
#include <nwlocal.h>
#include <nwmisc.h>


/*________________________ GetDiskUtilization _____________________________
|
| Output:   0		       --  SUCCESSFUL
|	    network error code --  UNSUCCESSFUL
|
| Comments:
|   This function returns the disk usage of a bindery object on a volume.
|   To determine the total disk space used, this call should be made
|   repetitively for all mounted volumes.  To determine the number of bytes
|   of disk space used, the usedBlocks should be multiplied by the number of
|   sectors and the bytes per sector. Currently network implementations
|   allocate the disk in 8 512-byte sectors per block, which is 4K per block.
|__________________________________________________________________________*/


int GetDiskUtilization(objectID, volumeNumber, usedDirectories,
		       usedFiles, usedBlocks)

long  objectID; 	/* Unique ID of the bindery object		     */
char  volumeNumber;	/* Volume for which statistics are requested (0..31) */
WORD *usedDirectories;	/* Receives the directories owned by the object      */
WORD *usedFiles;	/* Receives the files created by the object	     */
WORD *usedBlocks;	/* Receives the disk blocks used by the object	     */
{
BYTE	sendPacket[8], receivePacket[13];
int	ccode;

    *((int *)sendPacket) = 6;
    sendPacket[2] = 14;
    sendPacket[3] = volumeNumber;
    *((long *)(sendPacket + 4)) = LongSwap(objectID);

    *((int *)receivePacket) = 11;

    ccode = _ShellRequest((BYTE)227, sendPacket, receivePacket);
    if (ccode)
	return (ccode);

    if (usedDirectories != 0)
	*usedDirectories = IntSwap(*((int *)(receivePacket + 7)));
    if (usedFiles != 0)
	*usedFiles = IntSwap(*((int *)(receivePacket + 9)));
    if (usedBlocks != 0)
	*usedBlocks = IntSwap(*((int *)(receivePacket + 11)));

    return (0);
}
