/*	COPYRIGHT (c) 1989 by Novell, Inc.  All Rights Reserved.   */
#include <string.h>
#include <nwconn.h>
#include <nwlocal.h>
#include <nwmisc.h>

/*___________________ GetObjectConnectionNumbers __________________________
|
| Output:   Returns a 0 if successful or a network error code if unsuccessful.
|
| Comments:
|   This routine returns a list of all connections where an object is logged
|   in.  Connections are returned in a character array, with one connection
|   number per byte.  The number of connection numbers to be returned are
|   put into the variable numberOfConnections.
|____________________________________________________________________________*/

int GetObjectConnectionNumbers(objectName, objectType, numberOfConnections,
                               connectionList, maxConnections)

char *objectName;            /* Name of the bindery object for which
                                connection numbers are returned (maximum of
                                48 characters including the null terminator) */
WORD  objectType;            /* Type of the bindery object for which connection
                                numbers are returned                         */
WORD *numberOfConnections;   /* Receives the number of connection numbers that
                                the bindery object is logged into (0-100)    */
WORD *connectionList;        /* Receives a list of connection numbers of where
                                the bindery object is logged in (max 100 BYTES)*/
WORD  maxConnections;        /* Contains the maximum number of connection
                                numbers to return in connectionList           */
{
    char sendPacket[54], receivePacket[103];
    int ccode, offset;


    sendPacket[2] = 21;
    *((int *)(sendPacket + 3)) = IntSwap(objectType);
    sendPacket[5] = (char)((BYTE)strlen(objectName));
    strcpy(sendPacket + 6, objectName);
    *((int *)sendPacket) = 4 + sendPacket[5];

    *((int *)receivePacket) = 101;

    ccode = _ShellRequest((BYTE)227, (BYTE *)sendPacket, (BYTE *)receivePacket);
    if (ccode)
        return(ccode);

    *numberOfConnections = (WORD)(receivePacket[2]);

    if (*numberOfConnections > maxConnections)
        *numberOfConnections = maxConnections;
    if (*numberOfConnections)
        for( offset = -1; ++offset < *numberOfConnections;
             connectionList[offset] = (WORD)(receivePacket[3+offset]) );

    return (ccode);
}
