	INCLUDE c.mac

;**** AttachToFileServer -- attaches to a server
; Input;    char *serverName;	    /* The name of the server that should
;				       be attached to */
;	    WORD *connectionID;     /* Pointer where the server number will
;				       be returned when the connection is
;
; Output:   Returns a 0 if successful or one of the following codes if
;	    unsuccessful-
;	    0xf8 Connection already established (server number is returned).
;	    0xf9 There are no free connection slots on the given server.
;	    0xfa The shell already has connections with 8 servers, which is
;		   the current limit, there are no more slots available.
;	    0xfc The file server is unknown, its name and address were not
;		   in the bindry of the effective server.
;	    0xfe Bindry of current effective server is locked.
;	    0xff There was no response from the given server.
;
; Comments:
;   This routine will create an entry in the shell server table for the
;   new server and attach to that server.
;
; Notes:
;   Currently there is a limit of 8 connections to servers at the same time.
;***/

	DSeg
propertyName	db 'NET_ADDRESS', 0
	EndDS

	PExtern ReadPropertyValue
	DOSExterns

	PSeg

	ProcDef AttachToFileServer,<<serverName, dptr>,<connectionID, dptr>>
	sub	sp, 128 		;Save 128 byte data area
	PushSI
	PushDI
	PushES
;
;Set up parameters and call ReadPropertyValue to find the address of the
;  new server that is to be attached to
	xor	ax, ax
	IF	MODEL AND 1
	push	ax			;Push Nil for propertyFlags parameter
	push	ax
	push	ax			;Push Nil for moreSegments parameter
	push	ax
	push	ss			;Push address of 128 byte data parameter
	lea	bx, [bp - 128]
	push	bx
	inc	ax
	push	ax			;Push 1 for segment parameter
	push	ds
	mov	ax, offset dgroup:propertyName
	push	ax			;Push property name NET_ADDRESS
	mov	ax, 4
	push	ax			;Push 4 for objectType (4=file server)
	push	word ptr (serverName + 2)	;Push address of serverName
	push	word ptr (serverName)
	call	ReadPropertyValue
	add	sp, 24			;Remove parameters from stack
	ELSE
	push	ax			;Push Nil for propertyFlags parameter
	push	ax			;Push Nil for moreSegments parameter
	lea	bx, [bp - 128]
	push	bx			;Push address of 128 byte data parameter
	inc	ax
	push	ax			;Push 1 for segment parameter
	mov	ax, offset dgroup:propertyName
	push	ax			;Push property name NET_ADDRESS
	mov	ax, 4
	push	ax			;Push 4 for objectType (4 is file server)
	push	word ptr (serverName)	;Push address of serverName
	call	ReadPropertyValue
	add	sp, 14			;Remove parameters from stack
	ENDIF
	cmp	al, 0			;Check return value
	jz	short got_address
	cmp	al, 0feh
	jz	short bindry_locked
	mov	al, 0fch		;Return 0xfc when the server is unknown
bindry_locked:				;Return 0xfe when bindry is locked
	RetVal	byte, reg, al
	jmp	EndWithError
got_address:
;
;Get address of server table in es:si (call number 239)
	mov	ax, 0ef03h		;Function call 239
					;Option 3 is get server table address
	EnterDOS

	push	ds		; Save ds to restore at return
	push	es
	pop	ds		; ds:si point to server address table
	push	ss
	pop	es
	mov	di, bp
	sub	di, 128 	; es:di point to new server address
	push	bp		; Save bp so register can be used
	push	si		; Save the start of the server address table
	mov	bx, si		; bx indexes into the server address table
	mov	dx, 108h	; dh will count number of used slots
				; dl will count down table entries
	mov	ax, -1		; ax has index of first empty slot
	mov	bp, ax		; bp has index of slot with my order number
	cld

ScanServerTable:
	cmp	byte ptr [bx], 0
	jz	SlotNotUsed
	inc	dh
	lea	si, [bx + 2]
	mov	cx, 6 + 4
	push	di
 rep	cmpsb
	pop	di
	jnz	CheckNoMatch
		;The server is already connected at this slot
	neg	dl
	add	dl, 9	; Get the 1 based slot number
	pop	si
	pop	bp
	IF (Model AND 1) EQ 0
	pop	ds
	ENDIF
	LoadPtr si, connectionID, ds
	xor	dh, dh
	mov	[si], dx		;Return the server number
	IF (Model AND 1)
	pop	ds
	ENDIF
	RetVal	word, imm, 0f8h 	;Return already attached code
EndWithError:
	PopES
	PopDI
	PopSI
	add	sp, 128 		;Restore 128 byte data area to stack
	ResetD
	Return

NoSlotsAvailable:
	pop	si
	pop	bp
	pop	ds
	RetVal	word, imm, 0fah
	jmp	short EndWithError

CheckNoMatch:
	jb	ContinueScan
	cmp	bp, -1
	je	SetAsFirst
	mov	cl, [bx + 1]
	cmp	cl, ds: [bp + 1]
	ja	ContinueScan
SetAsFirst:
	mov	bp, bx
	jmp	short ContinueScan

SlotNotUsed:
	cmp	ax, -1
	jne	ContinueScan
	mov	ax, bx

ContinueScan:
	add	bx, 32
	dec	dl
	jnz	ScanServerTable

	cmp	ax, -1			; See if there were any empty slots
	je	NoSlotsAvailable

	mov	bx, ax			;bx gets offset of empty slot
	mov	si, di
	lea	di, [bx + 2]
	mov	ax, ds
	push	es
	pop	ds
	mov	es, ax
	mov	cx, 6 + 4 + 2
 rep	movsb				;Copy new address into table

	mov	ds, ax
	pop	si			;Get the address of the address table
	mov	ax, bx
	sub	ax, si
	push	ax			;Save index * 32 (zero based)

	mov	cx, 8
	mov	al, dh
	cmp	bp, -1
	je	OrderAtEnd

	mov	al, ds: [bp + 1]		;Get our order number

BumpUpOrderNumbers:
	cmp	byte ptr [si], 0
	jz	SkipThisOne
	cmp	byte ptr [si + 1], al
	jb	SkipThisOne
	inc	byte ptr [si + 1]
SkipThisOne:
	add	si, 32
	loop	BumpUpOrderNumbers

OrderAtEnd:
	mov	byte ptr [bx], 0ffh
	mov	[bx + 1], al

;Put the server name in the server name table (Advanced Netware 2.0)
;Get address of server name table in es:si (call number 239)
	mov	ax, 0ef04h		;Function call 239
	EnterDOS

	pop	ax			;ax gets index * 32 (zero based)
	mov	di, si
	add	di, ax
	shr	ax, 1			;ax has index * 16 (zero based)
	add	di, ax			;Index to the correct slot (48 byte entries)

	pop	bp
	pop	ds
	PushDS
	LoadPtr si, serverName, ds
	mov	cx, 48
 rep	movsb				;Copy the server name into the table
;
;Tell the shell to attach to the server (call number 241)
	mov	cl, 4
	shr	ax, cl			;ax has index (zero based)
	inc	ax			;ax has index (one based)
	mov	dl, al
	LoadPtr si, connectionID, ds
	mov	[si], ax
	PopDS
	mov	ax, 0f100h		;Shell function number 241
	EnterDOS
	PopES
	PopDI
	PopSI
	add	sp, 128 		;Restore 128 byte data area to stack
	RetVal	byte, reg, al
	ResetD
	Return
	ProcEnd AttachToFileServer

	EndPS

	End

