/*	COPYRIGHT (c) 1989 by Novell, Inc.  All Rights Reserved.   */
/*	COPYRIGHT (c) 1989 by Novell, Inc.  All Rights Reserved.   */
#ifndef SAP_H
#define SAP_H

/*____________________________________________________________________________


     Header file that includes the definitions and structures needed for

     the NETWARE API Service Advertising Protocals Logic

 ___________________________________________________________________________*/



   #ifndef PROLOG
       #include <prolog.h>
   #endif

   #define TRUE 		    1
   #define FALSE		    0

   #define SHORT_LIVED		 0x00
   #define SAP_SOCKET		0x452
   #define SAP_PACKET_TYPE	    2
   #define ONE_MINUTE		60*18
   #define IPX_EVENT_CANCELED	 0xFC
   #define SUCCESSFUL		    0
   #define FAILURE		   -1
   #define MIN(a,b)	     (a < b ? a : b)
   #define NOT_SUPPORTED	    1
   #define INVALID_QUERY_TYPE	    2
   #define PERIODIC_ID_PACKET	    2

/*__________________________________________________________________________*/



   typedef struct IPXAddress
    {
	BYTE	network[4];	/* high-low */
	BYTE	node[6];	/* high-low */
	WORD	socket; 	/* high-low */
    }IPXAddress;



/*__________________________________________________________________________*/

typedef struct IPXHeader
 {
    WORD	checkSum;		   /* high-low */
    WORD	length; 		   /* high-low */
    BYTE	transportControl;
    BYTE	packetType;
    IPXAddress	destination;
    IPXAddress	source;
 }IPXHeader;

/*__________________________________________________________________________*/




   typedef struct SAPHeader
    {
       WORD	     checksum;		   /* high-low 1's complement */
       WORD	     length;		   /* high-low unsigned int */
       BYTE	     transportControl;
       BYTE	     packetType;
       IPXAddress    destination;
       IPXAddress    source;
       WORD	     SAPPacketType;	   /* 2 or 4 */
       WORD	     serverType;	   /* assigned by Novell */
       BYTE	     serverName[48];	   /* VAP name */
       IPXAddress    serverAddress;	   /* server internetwork address */
       WORD	     interveningNetworks;  /* # of networks packet must traverse */
    } SAPHeader;




/*__________________________________________________________________________*/





   typedef struct SAPQueryPacket
    {
       WORD	     checksum;		   /* high-low 1's complement */
       WORD	     length;		   /* high-low unsigned int */
       BYTE	     transportControl;
       BYTE	     packetType;
       IPXAddress    destination;
       IPXAddress    source;
       WORD	     queryType; 	   /* high-low, 1 or 3 */
       WORD	     serverType;	   /* high-low, assigned by Novell */
    } SAPQueryPacket;



/*__________________________________________________________________________*/




   #ifndef ECB_STRUCTURES_DEFINED
      typedef struct ECBFragment
       {
	  #ifndef LC310
	      void    far *address;
	  #else
	      WORD    address[2];	      /* offset-segment */
	  #endif
	      WORD    size;		      /* low-high */
	} ECBFragment;
   #endif




/*__________________________________________________________________________*/




    typedef struct ECB
     {
	#ifndef LC310
	   void 	   far *linkAddress;
	   void 	   (far *ESRAddress)();
	#else
	   WORD 	   linkAddress[2];	   /* offset-segment */
	   WORD 	   ESRAddress[2];	   /* offset-segment */
	#endif
	   BYTE 	   inUseFlag;
	   BYTE 	   completionCode;
	   WORD 	   socketNumber;	    /* high-low */
	   BYTE 	   IPXWorkspace[4];	    /* N/A */
	   BYTE 	   driverWorkspace[12];     /* N/A */
	   BYTE 	   immediateAddress[6];     /* high-low */
	   WORD 	   fragmentCount;	    /* low-high */
	   ECBFragment	   fragmentDescriptor[2];
     } ECB;


/*__________________________________________________________________________*/


   /* SAP packet */

   typedef struct
    {
       ECB	   theECB;
       SAPHeader   packet;
    } SAP_BUFFER;



/*__________________________________________________________________________*/



   typedef struct
    {
       IPXHeader    Header;
       WORD	    ResponseType;	  /* HI - LO  */
       WORD	    ServerType; 	  /* HI - LO  */
       BYTE	    ServerName[48];
       BYTE	    Network[4]; 	  /* hi - lo  */
       BYTE	    Node[6];		  /* hi - lo  */
       WORD	    Socket;		  /* hi - lo  */
       WORD	    InterveningNetworks;  /* hi - lo  */
    } SAP;



/*__________________________________________________________________________*/


   typedef struct
    {
       ECB		 theECB;
       SAPQueryPacket	 SAPq;
    } SEND_PACKET;


/*__________________________________________________________________________*/



   typedef struct
    {
       ECB   theECB;
       SAP   SB;
    } RECEIVE_PACKET;


/*__________________________________________________________________________*/





/*__________________________________________________________________________*/


   #ifdef PROTOTYPE
      extern void far Advertiser(void);
      extern int  AdvertiseService(WORD, char *, WORD);
      extern int  InitializeSAP(void);
      extern int  IPXCancelEvent(ECB *);
      extern void cdecl IPXCloseSocket(WORD);
      extern void IPXDisconnectFromTarget(BYTE *);
      extern void cdecl IPXGetDataAddress(BYTE *, WORD *);
      extern void IPXGetInternetworkAddress(BYTE *);
      extern WORD cdecl IPXGetIntervalMarker(void);
      extern int  cdecl IPXGetLocalTarget(BYTE *, BYTE *, int *);
      extern BYTE cdecl IPXInitialize(void);
      extern void IPXListenForPacket(ECB *);
      extern int  cdecl IPXOpenSocket(WORD *, BYTE);
      extern int  cdecl _IPXPacket(ECB *, WORD);
      extern void cdecl _LoadDS(void);
      extern void cdecl IPXRelinquishControl(void);
      extern void cdecl _IPXrequest(WORD, ECB *, WORD);
      extern void IPXScheduleIPXEvent(WORD, ECB *);
      extern void IPXScheduleSpecialEvent(WORD, ECB *);
      extern void IPXSendPacket(ECB *);
   #else
      extern void far Advertiser();
      extern int  AdvertiseService();
      extern int  InitializeSAP();
      extern int  IPXCancelEvent();
      extern void cdecl IPXCloseSocket();
      extern void IPXDisconnectFromTarget();
      extern void cdecl IPXGetDataAddress();
      extern void IPXGetInternetworkAddress();
      extern WORD cdecl IPXGetIntervalMarker();
      extern int  cdecl IPXGetLocalTarget();
      extern void IPXGetProcAddress();
      extern BYTE cdecl IPXInitialize();
      extern void IPXListenForPacket();
      extern int  cdecl IPXOpenSocket();
      extern int  cdecl _IPXPacket();
      extern void cdecl _LoadDS();
      extern void cdecl IPXRelinquishControl();
      extern void cdecl _IPXrequest();
      extern void IPXScheduleIPXEvent();
      extern void IPXScheduleSpecialEvent();
      extern void IPXSendPacket();
   #endif

#endif
