/*	COPYRIGHT (c) 1989 by Novell, Inc.  All Rights Reserved.   */
#ifndef _PROLOG_H
#define _PROLOG_H
/* _______________________________________________________________________
	   File including definitions needed for LATTICE C,
	      MICROSOFT C, TURBO C, and WATCOM C
  ________________________________________________________________________*/
#ifndef BYTE
   #define BYTE  unsigned char
#endif

#ifndef WORD
   #define WORD  unsigned short
#endif

#ifndef DWORD
   #define DWORD  unsigned long
#endif

/*********************************** LC310 **********************************/

#ifdef LC310
  #define _ELIPSIS_
    #ifndef NARGS
      #define PROTOTYPE
    #endif

#ifndef memmove
#define memmove(dest,src,cnt) memcpy((char *)(dest),(char *)(src),(unsigned)(cnt))
#endif

#ifndef NULL
   #ifdef SPTR
      #define NULL 0
   #else
      #define NULL 0L
   #endif
#endif

#define cdecl

#endif

/******************************** WAT650 ************************************/


#ifdef __WATCOMC__
   #include <stdarg.h>
   #include <stddef.h>
   #define _ELIPSIS_ ...
   #define PROTOTYPE


   #ifndef O_RAW
       #define O_RAW O_BINARY
   #endif

   #ifndef NPrintF
       #define NPrintF printf
   #endif

   #ifndef NULL
       #if defined(M_I86LM) || defined(M_I86CM) || defined(M_I86HM)
	   #define NULL 0L
       #else
	   #define NULL 0
       #endif
   #endif

   #ifndef Free
       #define Free(p) (free(p), 0)
   #endif

   #ifndef ANSI
       #define ANSI
   #endif
#endif


/******************************** TURBO C ***********************************/

/*
    if running TURBO 'C' pretend to be Microsoft with prototypes.
*/

#ifdef __TURBOC__
    #define MSC 000
    #define LINT_ARGS
    #ifndef ANSI
	#define ANSI
    #endif
    #if defined(__TINY__)
	#define M_I86TM __TINY__
    #elif defined(__SMALL__)
	#define M_I86SM __SMALL__
    #elif defined(__MEDIUM__)
	#define M_I86MM __MEDIUM__
    #elif defined(__COMPACT__)
	#define M_I86CM __COMPACT__
    #elif defined(__LARGE__)
	#define M_I86LM __LARGE__
    #elif defined(__HUGE__)
	#define M_I86HM __HUGE__
    #endif
#endif

/******************************** MSC400 ************************************/

#ifdef MSC
    #define _ELIPSIS_ ...
    #ifdef LINT_ARGS
	#define PROTOTYPE
    #endif

    #if MSC == 400
	#ifndef memmove
	    #define memmove(dest,src,n) memcpy((char *)(dest),(char *)(src),n)
	#endif
    #endif

    #ifndef O_RAW
	#define O_RAW O_BINARY
    #endif

    #ifndef NPrintF
	#define NPrintF printf
    #endif

    #ifndef NULL
	#if defined(M_I86LM) || defined(M_I86CM) || defined(M_I86HM)
	    #define NULL 0L
	#else
	    #define NULL 0
	#endif
    #endif

    #ifndef Free
	#define Free(p) (free(p), 0)
    #endif
#endif

#ifdef MSC
    #if MSC == 510
	#ifndef ANSI
	    #define ANSI
	#endif
    #endif
#endif

/****************************************************************************/

#ifndef NOPROC
#define NOPROC ((int (*)())0)
#endif

#ifndef TRUE
#define TRUE	1
#define FALSE	0
#endif


#ifdef LC310
    #define FARDATAPTR(type,var) WORD	var[2]
    #define FARCODEPTR(type,var) WORD	var[2]
#else
    #define FARDATAPTR(type,var) type far *var
    #define FARCODEPTR(type,var) type (far *var)()
#endif

#ifndef __STDARG
#ifdef __TURBOC__
#include <stdarg.h>
#else
#ifndef __WATCOMC__
#ifndef _VA_LIST_DEFINED
typedef char *va_list;
#define _VA_LIST_DEFINED
#endif
#define va_start(ap,v) ap = (va_list)(&v) + (sizeof(v)>=2?sizeof(v):2)
#define va_arg(ap,t) ((t*)(ap += (sizeof(t)>=2?sizeof(t):2)))[(sizeof(t)>=2?-1:-2)]
#define va_end(ap) ap = NULL
#endif
#endif
#define __STDARG
#define va_Special_start(ap,v,bytes) ap = (va_list)((char *)(&v) + sizeof(v) + bytes)
#define va_Special_arg(ap,t) (*((t*)(ap = (va_list)((char *)ap - sizeof(t)))))
/******  USE THE FOLLOWING MACRO TO DO NOTHING ******/
#define va_Special_end(ap,v,n)
#endif

/******************************* DOS ERRORS *********************************/

#ifndef DOS_INVALID_FUNCTION_NUMBER

/* DOS errors */
#define DOS_INVALID_FUNCTION_NUMBER	 1
#define DOS_FILE_NOT_FOUND		 2
#define DOS_PATH_NOT_FOUND		 3
#define DOS_TOO_MANY_OPEN_FILES 	 4
#define DOS_ACCESS_DENIED		 5
#define DOS_INVALID_FILE_HANDLE 	 6
#define DOS_MEMORY_BLOCKS_DESTROYED	 7
#define DOS_INSUFFICIENT_MEMORY 	 8
#define DOS_INVALID_MEMORY_BLOCK_ADDR	 9
#define DOS_INVALID_ENVIRONMENT 	10
#define DOS_INVALID_FORMAT		11
#define DOS_INVALID_ACCESS_CODE 	12
#define DOS_INVALID_DATA		13
#define DOS_INVALID_DRIVE_SPECIFIED	15
#define DOS_ATTEMPT_TO_DEL_CURRENT_DIR	16
#define DOS_NOT_SAVE_DEVICE		17
#define DOS_NO_MORE_FILES		18
#define DOS_SHARING_VIOLATION		32
#define DOS_LOCK_VIOLATION		33

#endif



#endif
