// 
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
// KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR 
// PURPOSE.
// 
// Copyright 1993 Microsoft Corporation, all rights reserved.
// 
// 
/****************************************************************************/
/*
    Dialer ---- Windows TAPI sample application created as an illustration of the usage of Windows TAPI
    
    Dialer does the following 3 things :
    
    (1) initiates/drops calls
    (2) handles simple TAPI requests for other applications; initiating/dropping calls on their behalf
    (3) monitors incoming/outgoing calls and keeps a call log based on the user's request.
    
    dialer.h : contains dialer's extern function declaration as defined in dialer.c, inipref.c, and tapifu.c.
*/

/****************************************************************************/
/* global switches */

#define WIN31        /* this is a Windows 3.1 application */
#define STRICT       /* be bold! */

#define VER_MAJOR               1
#define VER_MINOR               0
#define VER_BUILD               125

/****************************************************************************/
/* include files */

#include <commdlg.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "dialhelp.h"
#include "dialerrc.h"

/****************************************************************************/
/* constant definitions */

#define errNone                 0
#define cchSzMax                256

#define errNoVoiceLine          1

/****************************************************************************/
/* functions defined in dialer.c */
/****************************************************************************/

HWND HwndDialerMain(void);
void DisableDialerDesktop(BOOL fDisable);
void DialerReInitTapi(void);

BOOL FDialerInitiateCall(char *szNumber,char *szName);
void FAR DisplayLineInUseDlg();
void FAR DisplayDialingPromptDlg(DWORD dwLineErrCode);

void ShowCallStatusDlg(LPCSTR szName,LPCSTR szNumber,LPCSTR szLocation,LPCSTR szCallingCard,LPCSTR szTranslatedSddress);
void UpdateCallStatusDlg(BOOL fCallIsActive,LPCSTR szName,LPCSTR szNumber);
void HideCallStatusDlg(void);

BOOL FLogCall(BOOL,LPSTR,LPSTR,time_t,time_t);
int IkszFromErrCode(DWORD errCode);
void FAR DialerFatalExit(DWORD errCode);
void DialerErrMessageBox(int stringID);

void DoubleUpAmpersandsInSz(char *sz,int cchSzBuffer);

/****************************************************************************/
/* functions defined in iniprefs.c */
/****************************************************************************/

int CchGetDialerProfileString(HANDLE hInst,int ikszSecName,int ikszFieldName,int ikszDefault,LPSTR lpszBuffer,int cchBuffer);
int WGetDialerProfileInt(HANDLE hInst,int ikszSecName,int ikszFieldName,int wDefault);

void SetDialerProfileString(HANDLE hInst,int ikszSecName,int ikszFieldName,LPSTR lpszVal);
void SetDialerProfileInt(HANDLE hInst,int ikszSecName,int ikszFieldName,int wVal);

void FAR GetSetINIScreenPos(HANDLE hInst,POINT *pptTopLeft,BOOL fGet);
void FAR GetSetCallLogWinRect(HANDLE hInst,HWND hwndCL,BOOL fGet); 

void FAR GetSetINIQuickDial(HANDLE hInst,WORD ips,char *szName,char *szNum,BOOL fGet);
void FAR GetAllINIQuickDials(HANDLE hInst,HWND hwndDialer);

void FAR GetLastDialedNumbers(HANDLE hInst,HWND hwndDialer);
void FAR SaveLastDialedNumbers(HANDLE hInst,HWND hwndDialer);

/****************************************************************************/
/* functions defined in tapifu.c */
/****************************************************************************/

/* TAPI init/clean functions */

DWORD ErrStartTapi(HANDLE hInst,LPCSTR szAppName);
void  TapiDone(void);   

BOOL FTapiAddrDLLPresent(void);

DWORD ErrInitCallingCardInfo(HANDLE hInst);
BOOL  FRegisterSimpleTapi(BOOL fRegister);  

/* Phone/Change Options... dialog related functions */

BOOL FAR FInitLineLBox(HWND hdlgDialingOption);
BOOL FAR FInitAddressLBox(HANDLE hInst,HWND hdlgDialingOption);
BOOL FAR FInitLocationLBox(HWND hdlg,WORD didLocation); 
BOOL FAR FInitCallingCardLBox(HWND hdlg,WORD didLocation,WORD didCallingCard); 
void FAR UpdateCallingCardLBoxSelection(HWND hdlg,WORD didLocation,WORD didCallingCard);
void FAR UpdatePreferedCardForLocation(HWND hdlg,WORD didLocation,WORD didCallingCard);

void UpdateCurrentLocation(HWND hdlg,WORD didLocation);
void UpdateCurrentCallingCard(HANDLE hInst,HWND hdlg,WORD didCallingCard);
void UpdateDialingOptionSettings(HANDLE hInst,HWND hdlgDialingOption);

/* calling related functions */

BOOL FCallInProgress(void);
void AbortTapiCallInProgress(void);
BOOL FInitiateCall(LPCSTR lpszDialString,LPCSTR lpszCalledParty);
BOOL FDropCurrentCall(void);
void TerminateCalls(HANDLE hInst);

void ProcessNextQueuedSTAPIRequest(void);

void GetCurCallTranslatedNumber(char *szNumber,WORD cchSzNumber,DWORD *pdwTranslateResults);
void AddRemoveCurCallFromTollList();
void SetCurCallName(char *szName);

