//THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
//ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
//THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
//
// Copyright  1993, 1994  Microsoft Corporation.  All Rights Reserved.
//
//  MODULE:     Xform.c
//
//  PURPOSE:    XForm routines
//
//  PLATFORMS:  Chicago, NT, Win32s
//
//  FUNCTIONS:  
//      CreateXFormWindow() - Creates XForm window
//      XFormProc() - Processes messages
//      XFormCreateProc() - WM_CREATE processor
//      XFormCommandProc() - WM_COMMAND processor
//      XFormPaintProc() - WM_PAINT processor
//      XFormDestroyProc() - WM_DESTROY processor
//      ResetXForm() - Resets xform
//      DrawXForm() - Draws xform
//
//  SPECIAL INSTRUCTIONS: N/A
//


#include <windows.h>
#include "gdidemo.h"
#include "xform.h"

VOID ResetXForm(HWND);
VOID DrawXForm(HWND);


//
//  FUNCTION: CreateXFormWindow()
//
//  PURPOSE: Creates XForm window
//

HWND FAR CreateXFormWindow(HWND hWndClient, int nItem)
{
    HANDLE          hInstance;
    MDICREATESTRUCT mcs;

    hInstance = GETINSTANCE(hWndClient);

    // Initialize the MDI create struct for creation of the
    // test window.
    mcs.szClass = XFORMCLASS;
    mcs.szTitle = XFORMTITLE;
    mcs.hOwner  = hInstance;
    mcs.x       = CW_USEDEFAULT;
    mcs.y       = CW_USEDEFAULT;
    mcs.cx      = CW_USEDEFAULT;
    mcs.cy      = CW_USEDEFAULT;
    mcs.style   = 0l;
    mcs.lParam  = (LONG)nItem;

    return((HWND)SendMessage(hWndClient,WM_MDICREATE,0,(LONG)(LPMDICREATESTRUCT)&mcs));
}


//
//  FUNCTION: XFormProc()
//
//  PURPOSE: Processes messages
//

LONG APIENTRY XFormProc(HWND hWnd, UINT wMsg, WPARAM wParam, LONG lParam)
{
    switch(wMsg) {
    case WM_CREATE:
        XFormCreateProc(hWnd);
        break;

    case WM_MOVE:
        ResetXForm(hWnd);
        break;

    case WM_TIMER:
        DrawXForm(hWnd);
        break;

    case WM_COMMAND:
        XFormCommandProc(hWnd,wParam,lParam);
        break;

    case WM_PAINT:
        XFormPaintProc(hWnd);
        break;

    case WM_DESTROY:
        XFormDestroyProc(hWnd);
        break;

    default:
        return(DefMDIChildProc(hWnd,wMsg,wParam,lParam));
    }
    return(0l);
}


//
//  FUNCTION: XFormCreateProc()
//
//  PURPOSE: WM_CREATE processor
//

BOOL XFormCreateProc(HWND hWnd)
{
    PXFORMDATA pxd;

#ifndef NOT_IMPLEMENTED
    RECT       rect;
    int        dx,dy;
#endif

    if (AllocWindowInfo(hWnd,sizeof(XFORMDATA))) {
        if (pxd = (PXFORMDATA)LockWindowInfo(hWnd)) {

#ifndef NOT_IMPLEMENTED
            GetClientRect(hWnd,&rect);

            dx = (rect.right + rect.left) >> 4;
            dy = (rect.bottom + rect.top) >> 4;

            pxd->pObject[0].x = dx << 1;
            pxd->pObject[0].y = 0;
            pxd->pObject[1].x = dx;
            pxd->pObject[1].y = dy;
            pxd->pObject[2].x = 0;
            pxd->pObject[2].y = dy;
            pxd->pObject[3].x = dx << 1;
            pxd->pObject[3].y = 0;
            pxd->nObject      = 4;

            pxd->xForm.eM11 = (float) 0.866;
            pxd->xForm.eM12 = (float) 0.5;
            pxd->xForm.eM21 = (float)-0.5;
            pxd->xForm.eM22 = (float) 0.866;
            pxd->xForm.eDx  = (float) 0;
            pxd->xForm.eDy  = (float) 0;

#endif

            UnlockWindowInfo(hWnd);
            SetTimer(hWnd,1,500,NULL);
            return(TRUE);
        }
        FreeWindowInfo(hWnd);
    }
    return(FALSE);
}


//
//  FUNCTION: XFormCommandProc()
//
//  PURPOSE: WM_COMMAND processor
//

BOOL XFormCommandProc(HWND hWnd, WPARAM wParam, LONG lParam)
{
    hWnd   = hWnd;
    wParam = wParam;
    lParam = lParam;

    return(TRUE);
}


//
//  FUNCTION: XFormPaintProc()
//
//  PURPOSE: WM_PAINT processor
//

VOID XFormPaintProc(HWND hWnd)
{
    HDC         hDC;
    PAINTSTRUCT ps;

    if (hDC = BeginPaint(hWnd,&ps))
        EndPaint(hWnd,&ps);
    ResetXForm(hWnd);

    return;
}


//
//  FUNCTION: XFormDestroyProc()
//
//  PURPOSE: WM_DESTROY processor
//

VOID XFormDestroyProc(HWND hWnd)
{
    KillTimer(hWnd,1);
    FreeWindowInfo(hWnd);
    return;
}


//
//  FUNCTION: ResetXForm()
//
//  PURPOSE: Resets xform
//

VOID ResetXForm(HWND hWnd)
{
    PXFORMDATA pxd;
    HDC        hDC;

#ifndef NOT_IMPLEMENTED
    RECT       rect;
#endif

    if (pxd = (PXFORMDATA)LockWindowInfo(hWnd)) {
        if (hDC = GetDC(hWnd)) {

#ifndef NOT_IMPLEMENTED

            GetClientRect(hWnd,&rect);
            BitBlt(hDC,0,0,rect.right,rect.bottom,(HDC)0,0,0,0);

            SetViewportOrgEx(hDC,rect.right >> 1,rect.bottom >> 1,NULL);
            SetWorldTransform(hDC,(LPXFORM)&pxd->xForm);
            Polyline(hDC,pxd->pObject,pxd->nObject);
            ModifyWorldTransform(hDC,(LPXFORM)&pxd->xForm,MWT_IDENTITY);

            // I have to put this in since GDI currently doesn't
            // reset the drawing attributes -- 5/24/91
            //
            SetViewportOrgEx(hDC,0,0,NULL);

#endif

            ReleaseDC(hWnd,hDC);
        }
        UnlockWindowInfo(hWnd);
    }
    return;
}


//
//  FUNCTION: DrawXForm()
//
//  PURPOSE: Draws xform
//

VOID DrawXForm(HWND hWnd)
{
    PXFORMDATA pxd;
    HDC        hDC;
#ifndef NOT_IMPLEMENTED
    XFORM      xForm;
    RECT       rect;
#endif

    if (pxd = (PXFORMDATA)LockWindowInfo(hWnd)) {
        if (hDC = GetDC(hWnd)) {

#ifndef NOT_IMPLEMENTED

            GetClientRect(hWnd,&rect);
            SetViewportOrgEx(hDC,rect.right >> 1, rect.bottom >> 1,NULL);

            SetWorldTransform(hDC,(LPXFORM)&pxd->xForm);
            Polyline(hDC,pxd->pObject,pxd->nObject);

            ModifyWorldTransform(hDC,(LPXFORM)&pxd->xForm,MWT_RIGHTMULTIPLY);
            Polyline(hDC,pxd->pObject,pxd->nObject);

            GetWorldTransform(hDC,(LPXFORM)&xForm);
            pxd->xForm.eM11 = xForm.eM11;
            pxd->xForm.eM12 = xForm.eM12;
            pxd->xForm.eM21 = xForm.eM21;
            pxd->xForm.eM22 = xForm.eM22;
            pxd->xForm.eDx  = xForm.eDx;
            pxd->xForm.eDy  = xForm.eDy;

            ModifyWorldTransform(hDC,(LPXFORM)&pxd->xForm,MWT_IDENTITY);

            // I have to put this in since GDI currently doesn't
            // reset the drawing attributes -- 5/24/91
            //
            SetViewportOrgEx(hDC,0,0,NULL);

#endif
            ReleaseDC(hWnd,hDC);
        }
        UnlockWindowInfo(hWnd);
    }
    return;
}
