//THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
//ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
//THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
//
// Copyright  1993, 1994  Microsoft Corporation.  All Rights Reserved.
//
//  MODULE:     Wininfo.c
//
//  PURPOSE:    This module contains the routines which deal with obtaining the extra
//              object information associated with a window.  For these to work, the
//              window class must reserve the 0th word of the win-class object to be
//              used to hold global-memory handle.
//
//  PLATFORMS:  Chicago, NT, Win32s
//
//  FUNCTIONS:
//      AllocWindowInfo() - This routine allocates memory out of the application heap for storing
//              extra memory for the window.  It is alway referenced as offset 0.
//      LockWindowInfo() - This routine de-references the extra-memory associated with the window.
//              it locks the object and gives the caller a pointer to the memory.
//      UnlockWindowInfo() - This routine unlocks the memory the caller has previously locked.
//      FreeWindowInfo() - This routine frees the object memory associated with the window.
//
//  SPECIAL INSTRUCTIONS: N/A
//


#include <windows.h>
#include "gdidemo.h"


//
//  FUNCTION: AllocWindowInfo()
//
//  PURPOSE: This routine allocates memory out of the application heap for storing
//           extra memory for the window.  It is alway referenced as offset 0.
//

BOOL FAR AllocWindowInfo(HWND hWnd, WORD wSize)
{
    HANDLE hsd;

    if (hsd = LocalAlloc(LHND,(WORD)wSize)) {
        SetWindowLong(hWnd,0,(LONG)hsd);
        return(TRUE);
    }
    return(FALSE);
}


//
//  FUNCTION: LockWindowInfo()
//
//  PURPOSE: This routine de-references the extra-memory associated with the window.
//           it locks the object and gives the caller a pointer to the memory.
//

PVOID FAR LockWindowInfo(HWND hWnd)
{
    HANDLE hMem;
    PVOID  pMem;

    pMem = NULL;
    if (hMem = (HANDLE)GetWindowLong(hWnd,0))
        pMem = (PVOID)LocalLock(hMem);
    return(pMem);
}


//
//  FUNCTION: UnlockWindowInfo()
//
//  PURPOSE: This routine unlocks the memory the caller has previously locked.
//

BOOL FAR UnlockWindowInfo(HWND hWnd)
{
    HANDLE hMem;

    if (hMem = (HANDLE)GetWindowLong(hWnd,0))
        if (!LocalUnlock(hMem))
            return(TRUE);
    return(FALSE);
}


//
//  FUNCTION: FreeWindowInfo()
//
//  PURPOSE: This routine frees the object memory associated with the window.
//

BOOL FAR FreeWindowInfo(HWND hWnd)
{
    LOCALHANDLE hMem;

    if (hMem = (HANDLE)GetWindowLong(hWnd,0))
        LocalFree(hMem);
    return(TRUE);
}
