//THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
//ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
//THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
//
// Copyright  1993, 1994  Microsoft Corporation.  All Rights Reserved.
//
//  MODULE:     Maze.c
//
//  PURPOSE:    Maze routines
//
//  PLATFORMS:  Chicago, NT, Win32s
//
//  FUNCTIONS:  
//      CreateMazeWindow() - Creates the maze window
//      MazeProc() - Processes messages for the maze window
//      MazeCreateProc() - Initialization for WM_CREATE
//      MazeCommandProc() - WM_COMMAND processor
//      MazePaintProc() - WM_PAINT processor
//      MazeDestroyProc() - WM_DESTROY processor
//      DrawMaze() - Draws maze (not really)
//
//  SPECIAL INSTRUCTIONS: N/A
//

#include <windows.h>
#include "gdidemo.h"
#include "maze.h"


//
//  FUNCTION: CreateMazeWindow()
//
//  PURPOSE: Creates the maze window
//

HWND FAR CreateMazeWindow(HWND hWndClient, int nItem)
{
    HANDLE          hInstance;
    MDICREATESTRUCT mcs;

    hInstance = GETINSTANCE(hWndClient);

    // Initialize the MDI create struct for creation of the
    // test window.

    mcs.szClass = MAZECLASS;
    mcs.szTitle = MAZETITLE;
    mcs.hOwner  = hInstance;
    mcs.x       = CW_USEDEFAULT;
    mcs.y       = CW_USEDEFAULT;
    mcs.cx      = CW_USEDEFAULT;
    mcs.cy      = CW_USEDEFAULT;
    mcs.style   = 0l;
    mcs.lParam  = (LONG)nItem;

    return((HWND)SendMessage(hWndClient,WM_MDICREATE,0,(LONG)(LPMDICREATESTRUCT)&mcs));
}


//
//  FUNCTION: MazeProc()
//
//  PURPOSE: Processes messages for the maze window
//
//  MESSAGES:
//
//      WM_CREATE - initialization
//      WM_COMMAND - input received
//      WM_TIMER - draw maze
//      WM_PAINT - do any needed painting
//      WM_DESTROY - clean up
//

LONG APIENTRY MazeProc(HWND hWnd, UINT wMsg, WPARAM wParam, LONG lParam)
{
    switch(wMsg) {
    case WM_CREATE:
        MazeCreateProc(hWnd);
        break;

    case WM_COMMAND:
        MazeCommandProc(hWnd,wParam,lParam);
        break;

    case WM_TIMER:
        DrawMaze(hWnd);
        break;

    case WM_PAINT:
        MazePaintProc(hWnd);
        break;

    case WM_DESTROY:
        MazeDestroyProc(hWnd);
        break;

    default:
        return(DefMDIChildProc(hWnd,wMsg,wParam,lParam));
    }
    return(0l);
}


//
//  FUNCTION: MazeCreateProc()
//
//  PURPOSE:  Initialization for WM_CREATE
//

BOOL MazeCreateProc(HWND hWnd)
{
    PMAZEDATA ppd;

    if(AllocWindowInfo(hWnd,sizeof(MAZEDATA))) {
        if(ppd = (PMAZEDATA)LockWindowInfo(hWnd)) {
            UnlockWindowInfo(hWnd);
            return(TRUE);
        }
        FreeWindowInfo(hWnd);
    }
    return(FALSE);
}


//
//  FUNCTION: MazeCommandProc()
//
//  PURPOSE: WM_COMMAND processor
//

BOOL MazeCommandProc(HWND hWnd, WPARAM wParam, LONG lParam)
{
    hWnd   = hWnd;
    wParam = wParam;
    lParam = lParam;

    return(TRUE);
}


//
//  FUNCTION: MazePaintProc()
//
//  PURPOSE: WM_PAINT processor
//

VOID MazePaintProc(HWND hWnd)
{
    HDC         hDC;
    PAINTSTRUCT ps;

    if(hDC = BeginPaint(hWnd,&ps))
        EndPaint(hWnd,&ps);

    return;
}


//
//  FUNCTION: MazeDestroyProc()
//
//  PURPOSE: WM_DESTROY processor
//

VOID MazeDestroyProc(HWND hWnd)
{
    KillTimer(hWnd,1);
    FreeWindowInfo(hWnd);
    return;
}


//
//  FUNCTION: DrawMaze()
//
//  PURPOSE: Draws maze (not really)
//

VOID DrawMaze(HWND hWnd)
{
    hWnd = hWnd;

    return;
}
