/****************************************************************************
                    Microsoft RPC Version 1.0
                 Copyright Microsoft Corp. 1992
                        usrdef Example

    FILE:       usrdefp.c
    
    PURPOSE:    Remote procedures that are linked with the server
                side of RPC distributed application
    
    FUNCTIONS:  UsrdefProc() -
    
    COMMENTS:   This distributed application uses a user-defined handle.

****************************************************************************/

#include <stdlib.h>
#include <stdio.h>    
#include "usrdef.h"    // header file generated by MIDL compiler

void UsrdefProc(DATA_HANDLE_TYPE dh, unsigned char * pszString)
{
    printf("%s\n", pszString);
}

void Shutdown(DATA_HANDLE_TYPE dh)
{
    RPC_STATUS status;

    printf("Calling RpcMgmtStopServerListening\n");
    status = RpcMgmtStopServerListening(NULL);
    printf("RpcMgmtStopServerListening returned: 0x%x\n", status);
    if (status) {
        exit(status);
    }

    printf("Calling RpcServerUnregisterIf\n");
    status = RpcServerUnregisterIf(NULL, NULL, FALSE);
    printf("RpcServerUnregisterIf returned 0x%x\n", status);
    if (status) {
        exit(status);
    }
}

/* end file usrdefp.c */
