/*****************************************************************************\
*                                                                             *
* rna.h -       Remote Network Access (RNA) Session API functions, types, and *
*               definitions                                                   *
*                                                                             *
*               Version 1.00                                                  *
*                                                                             *
*               Copyright (c) 1992-1993, Microsoft Corp. All rights reserved. *
*                                                                             *
******************************************************************************/

#ifndef _RNA_H_
#define _RNA_H_


#ifndef NETCONS_INCLUDED

#define NETCONS_INCLUDED

#define UNLEN       256                 // Maximum user name length
#define PWLEN       256                 // Maximum password length
#define DNLEN       15                  // Maximum domain name length
#define NETBIOS_NAME_LEN  16            // NetBIOS net name (bytes)

#define LM20_PWLEN  14                  // LM 2.0 Maximum password length

//
//        Constants used with encryption
//

#define CRYPT_KEY_LEN           7
#define CRYPT_TXT_LEN           8
#define ENCRYPTED_PWLEN         16
#define SESSION_PWLEN           24
#define SESSION_CRYPT_KLEN      21

#endif   // NETCONS_INCLUDED

#define RAS_MaxEntryName   255
#define RAS_MaxDeviceName  63
#define RAS_MaxDeviceType  15
#define RAS_MaxPhoneNumber 47

typedef HANDLE              HRASCONN;
typedef HRASCONN    FAR*    LPHRASCONN;

/* Identifies an active connection.  (See RasEnumConnections)
*/

typedef struct _RasConnA {
    DWORD    dwSize;
    HRASCONN hrasconn;
    char     szEntryName[ RAS_MaxEntryName + 1 ];
    char     szDeviceType[ RAS_MaxDeviceType + 1 ];
    char     szDeviceName[ RAS_MaxDeviceName + 1 ];
}   RASCONNA, FAR* LPRASCONNA;

/* Enumerates intermediate states to a connection.  (See RasDial)
*/
#define RASCS_PAUSED 0x1000
#define RASCS_DONE   0x2000

typedef enum
{
    RASCS_OpenPort = 0,
    RASCS_PortOpened,
    RASCS_ConnectDevice,
    RASCS_DeviceConnected,
    RASCS_AllDevicesConnected,
    RASCS_Authenticate,
    RASCS_AuthNotify,
    RASCS_AuthRetry,
    RASCS_AuthCallback,
    RASCS_AuthChangePassword,
    RASCS_AuthProject,
    RASCS_AuthLinkSpeed,
    RASCS_AuthAck,
    RASCS_ReAuthenticate,
    RASCS_Authenticated,
    RASCS_PrepareForCallback,
    RASCS_WaitForModemReset,
    RASCS_WaitForCallback,
    RASCS_StartAuthentication,
    RASCS_SendCallback,
    RASCS_CallbackComplete,

    RASCS_Interactive = RASCS_PAUSED,
    RASCS_RetryAuthentication,
    RASCS_CallbackSetByCaller,
    RASCS_PasswordExpired,
    RASCS_RetryLogon,

    RASCS_Connected = RASCS_DONE,
    RASCS_Disconnected,
    RASCS_StartClosing,
    RASCS_Closing,
    RASCS_Closed,

    RASCS_Invalid
}   RASCONNSTATE, FAR* LPCONNSTATE;


/* Describes the status of a RAS connection.  (See RasGetConnectStatus)
*/

typedef struct _RasConnStatusA {
    DWORD        dwSize;
    RASCONNSTATE rasconnstate;
    DWORD        dwError;
    char         szDeviceType[ RAS_MaxDeviceType + 1 ];
    char         szDeviceName[ RAS_MaxDeviceName + 1 ];
}   RASCONNSTATUSA, FAR* LPRASCONNSTATUSA;

/* Describes connection establishment parameters.  (See RasDial)
*/
typedef struct  _RasDialParamsA  {
    DWORD   dwSize;
    char    szEntryName[ RAS_MaxEntryName + 1 ];
    char    szPhoneNumber[ RAS_MaxPhoneNumber + 1 ];
    char    szCallbackNumber[ RAS_MaxPhoneNumber + 1 ];
    char    szUsername[ UNLEN + 1 ];
    char    szPassWord[ PWLEN + 1 ];
    char    szDomain[ DNLEN + 1 ];
}   RASDIALPARAMSA, FAR* LPRASDIALPARAMSA;

/* Describes the addressbook entry name
*/
typedef struct  _RasEntryNameA   {
    DWORD   dwSize;
    char    szEntryName[RAS_MaxEntryName+1];
}   RASENTRYNAMEA, FAR* LPRASENTRYNAMEA;

/* Prototype for caller's RasDial callback handler.  Arguments are the message
** ID (currently always WM_RASDIALEVENT), the current RASCONNSTATE and the
** error that has occurred (or 0 if none).
*/
#define WM_RASDIALEVENT  0xCCCD
typedef VOID (CALLBACK *RASDIALFUNC)( UINT, RASCONNSTATE, DWORD );

/* Remote Network Access Session API function prototypes.
*/
DWORD WINAPI RasEnumEntries ( LPSTR, LPSTR, LPRASENTRYNAMEA, LPDWORD, LPDWORD );
DWORD WINAPI RasEnumConnections( LPRASCONNA, LPDWORD, LPDWORD );
DWORD WINAPI RasGetConnectStatus( HRASCONN, LPRASCONNSTATUSA );
DWORD WINAPI RasDial( LPSTR, LPSTR, LPRASDIALPARAMSA, LPVOID, RASDIALFUNC, LPHRASCONN );
DWORD WINAPI RasGetErrorString( DWORD, LPSTR, DWORD );
DWORD WINAPI RasHangUp( HRASCONN );

/* Return code from Remote Network Access
*/

#define SUCCESS                              ERROR_SUCCESS

#define RASBASE                              600
#define PENDING                              (RASBASE+0)
#define ERROR_INVALID_PORT_HANDLE            (RASBASE+1)
#define ERROR_PORT_ALREADY_OPEN              (RASBASE+2)
#define ERROR_BUFFER_TOO_SMALL               (RASBASE+3)
#define ERROR_WRONG_INFO_SPECIFIED           (RASBASE+4)
#define ERROR_CANNOT_SET_PORT_INFO           (RASBASE+5)
#define ERROR_PORT_NOT_CONNECTED             (RASBASE+6)
#define ERROR_EVENT_INVALID                  (RASBASE+7)
#define ERROR_DEVICE_DOES_NOT_EXIST          (RASBASE+8)
#define ERROR_DEVICETYPE_DOES_NOT_EXIST      (RASBASE+9)
#define ERROR_INVALID_BUFFER                 (RASBASE+10)
#define ERROR_ROUTE_NOT_AVAILABLE            (RASBASE+11)
#define ERROR_ROUTE_NOT_ALLOCATED            (RASBASE+12)
#define ERROR_INVALID_COMPRESSION_SPECIFIED  (RASBASE+13)
#define ERROR_OUT_OF_BUFFERS                 (RASBASE+14)
#define ERROR_PORT_NOT_FOUND                 (RASBASE+15)
#define ERROR_ASYNC_REQUEST_PENDING          (RASBASE+16)
#define ERROR_ALREADY_DISCONNECTING          (RASBASE+17)
#define ERROR_PORT_NOT_OPEN                  (RASBASE+18)
#define ERROR_PORT_DISCONNECTED              (RASBASE+19)
#define ERROR_NO_ENDPOINTS                   (RASBASE+20)
#define ERROR_CANNOT_OPEN_PHONEBOOK          (RASBASE+21)
#define ERROR_CANNOT_LOAD_PHONEBOOK          (RASBASE+22)
#define ERROR_CANNOT_FIND_PHONEBOOK_ENTRY    (RASBASE+23)
#define ERROR_CANNOT_WRITE_PHONEBOOK         (RASBASE+24)
#define ERROR_CORRUPT_PHONEBOOK              (RASBASE+25)
#define ERROR_CANNOT_LOAD_STRING             (RASBASE+26)
#define ERROR_KEY_NOT_FOUND                  (RASBASE+27)
#define ERROR_DISCONNECTION                  (RASBASE+28)
#define ERROR_REMOTE_DISCONNECTION           (RASBASE+29)
#define ERROR_HARDWARE_FAILURE               (RASBASE+30)
#define ERROR_USER_DISCONNECTION             (RASBASE+31)
#define ERROR_INVALID_SIZE                   (RASBASE+32)
#define ERROR_PORT_NOT_AVAILABLE             (RASBASE+33)
#define ERROR_CANNOT_PROJECT_CLIENT          (RASBASE+34)
#define ERROR_UNKNOWN                        (RASBASE+35)
#define ERROR_WRONG_DEVICE_ATTACHED          (RASBASE+36)
#define ERROR_BAD_STRING                     (RASBASE+37)
#define ERROR_REQUEST_TIMEOUT                (RASBASE+38)
#define ERROR_CANNOT_GET_LANA                (RASBASE+39)
#define ERROR_NETBIOS_ERROR                  (RASBASE+40)
#define ERROR_SERVER_OUT_OF_RESOURCES        (RASBASE+41)
#define ERROR_NAME_EXISTS_ON_NET             (RASBASE+42)
#define ERROR_SERVER_GENERAL_NET_FAILURE     (RASBASE+43)
#define WARNING_MSG_ALIAS_NOT_ADDED          (RASBASE+44)
#define ERROR_AUTH_INTERNAL                  (RASBASE+45)
#define ERROR_RESTRICTED_LOGON_HOURS         (RASBASE+46)
#define ERROR_ACCT_DISABLED                  (RASBASE+47)
#define ERROR_PASSWD_EXPIRED                 (RASBASE+48)
#define ERROR_NO_DIALIN_PERMISSION           (RASBASE+49)
#define ERROR_SERVER_NOT_RESPONDING          (RASBASE+50)
#define ERROR_FROM_DEVICE                    (RASBASE+51)
#define ERROR_UNRECOGNIZED_RESPONSE          (RASBASE+52)
#define ERROR_MACRO_NOT_FOUND                (RASBASE+53)
#define ERROR_MACRO_NOT_DEFINED              (RASBASE+54)
#define ERROR_MESSAGE_MACRO_NOT_FOUND        (RASBASE+55)
#define ERROR_DEFAULTOFF_MACRO_NOT_FOUND     (RASBASE+56)
#define ERROR_FILE_COULD_NOT_BE_OPENED       (RASBASE+57)
#define ERROR_DEVICENAME_TOO_LONG            (RASBASE+58)
#define ERROR_DEVICENAME_NOT_FOUND           (RASBASE+59)
#define ERROR_NO_RESPONSES                   (RASBASE+60)
#define ERROR_NO_COMMAND_FOUND               (RASBASE+61)
#define ERROR_WRONG_KEY_SPECIFIED            (RASBASE+62)
#define ERROR_UNKNOWN_DEVICE_TYPE            (RASBASE+63)
#define ERROR_ALLOCATING_MEMORY              (RASBASE+64)
#define ERROR_PORT_NOT_CONFIGURED            (RASBASE+65)
#define ERROR_DEVICE_NOT_READY               (RASBASE+66)
#define ERROR_READING_INI_FILE               (RASBASE+67)
#define ERROR_NO_CONNECTION                  (RASBASE+68)
#define ERROR_BAD_USAGE_IN_INI_FILE          (RASBASE+69)
#define ERROR_READING_SECTIONNAME            (RASBASE+70)
#define ERROR_READING_DEVICETYPE             (RASBASE+71)
#define ERROR_READING_DEVICENAME             (RASBASE+72)
#define ERROR_READING_USAGE                  (RASBASE+73)
#define ERROR_READING_MAXCONNECTBPS          (RASBASE+74)
#define ERROR_READING_MAXCARRIERBPS          (RASBASE+75)
#define ERROR_LINE_BUSY                      (RASBASE+76)
#define ERROR_VOICE_ANSWER                   (RASBASE+77)
#define ERROR_NO_ANSWER                      (RASBASE+78)
#define ERROR_NO_CARRIER                     (RASBASE+79)
#define ERROR_NO_DIALTONE                    (RASBASE+80)
#define ERROR_IN_COMMAND                     (RASBASE+81)
#define ERROR_WRITING_SECTIONNAME            (RASBASE+82)
#define ERROR_WRITING_DEVICETYPE             (RASBASE+83)
#define ERROR_WRITING_DEVICENAME             (RASBASE+84)
#define ERROR_WRITING_MAXCONNECTBPS          (RASBASE+85)
#define ERROR_WRITING_MAXCARRIERBPS          (RASBASE+86)
#define ERROR_WRITING_USAGE                  (RASBASE+87)
#define ERROR_WRITING_DEFAULTOFF             (RASBASE+88)
#define ERROR_READING_DEFAULTOFF             (RASBASE+89)
#define ERROR_EMPTY_INI_FILE                 (RASBASE+90)
#define ERROR_AUTHENTICATION_FAILURE         (RASBASE+91)
#define ERROR_PORT_OR_DEVICE                 (RASBASE+92)
#define ERROR_NOT_BINARY_MACRO               (RASBASE+93)
#define ERROR_DCB_NOT_FOUND                  (RASBASE+94)
#define ERROR_STATE_MACHINES_NOT_STARTED     (RASBASE+95)
#define ERROR_STATE_MACHINES_ALREADY_STARTED (RASBASE+96)
#define ERROR_PARTIAL_RESPONSE_LOOPING       (RASBASE+97)
#define ERROR_UNKNOWN_RESPONSE_KEY           (RASBASE+98)
#define ERROR_RECV_BUF_FULL                  (RASBASE+99)
#define ERROR_CMD_TOO_LONG                   (RASBASE+100)
#define ERROR_UNSUPPORTED_BPS                (RASBASE+101)
#define ERROR_UNEXPECTED_RESPONSE            (RASBASE+102)
#define ERROR_INTERACTIVE_MODE               (RASBASE+103)
#define ERROR_BAD_CALLBACK_NUMBER            (RASBASE+104)
#define ERROR_INVALID_AUTH_STATE             (RASBASE+105)
#define ERROR_WRITING_INITBPS                (RASBASE+106)
#define ERROR_X25_DIAGNOSTIC                 (RASBASE+107)
#define ERROR_ACCT_EXPIRED                   (RASBASE+108)
#define ERROR_CHANGING_PASSWORD              (RASBASE+109)
#define ERROR_OVERRUN                        (RASBASE+110)
#define ERROR_RASMAN_CANNOT_INITIALIZE	     (RASBASE+111)
#define ERROR_BIPLEX_PORT_NOT_AVAILABLE      (RASBASE+112)
#define ERROR_NO_ACTIVE_ISDN_LINES           (RASBASE+113)
#define ERROR_NO_ISDN_CHANNELS_AVAILABLE     (RASBASE+114)
#define ERROR_TOO_MANY_LINE_ERRORS           (RASBASE+115)

#define RASBASEEND			     (RASBASE+115)

/* Return code exclusively from Remote Network Access
*/

#define RNABASE                               (RASBASEEND+1)

#define ERROR_INVALID_SMM                     (RNABASE+0)
#define ERROR_SMM_UNINITIALIZED               (RNABASE+1)
#define ERROR_NO_MAC_FOR_PORT                 (RNABASE+2)
#define ERROR_SMM_TIMEOUT                     (RNABASE+3)

#define ERROR_ALLOCATED                       (RNABASE+4)
#define ERROR_BADDEVICEID                     (RNABASE+5)
#define ERROR_BEARERMODEUNAVAIL               (RNABASE+6)
#define ERROR_CALLPRIVUNCHANGED               (RNABASE+7)
#define ERROR_CALLUNAVAIL                     (RNABASE+8)
#define ERROR_COMPLETIONOVERRUN               (RNABASE+9)
#define ERROR_CONFERENCEFULL                  (RNABASE+10)
#define ERROR_DIALBILLING                     (RNABASE+11)
#define ERROR_DIALDIALTONE                    (RNABASE+12)
#define ERROR_DIALPROMPT                      (RNABASE+13)
#define ERROR_DIALQUIET                       (RNABASE+14)
#define ERROR_INCOMPATIBLEAPIVERSION          (RNABASE+15)
#define ERROR_INCOMPATIBLEEXTVERSION          (RNABASE+16)
#define ERROR_INIFILECORRUPT                  (RNABASE+17)
#define ERROR_INUSE                           (RNABASE+18)
#define ERROR_INVALADDRESS                    (RNABASE+19)
#define ERROR_INVALADDRESSID                  (RNABASE+20)
#define ERROR_INVALADDRESSMODE                (RNABASE+21)
#define ERROR_INVALADDRESSSTATE               (RNABASE+22)
#define ERROR_INVALAPPHANDLE                  (RNABASE+23)
#define ERROR_INVALAPPNAME                    (RNABASE+24)
#define ERROR_INVALBEARERMODE                 (RNABASE+25)
#define ERROR_INVALCALLCOMPLMODE              (RNABASE+26)
#define ERROR_INVALCALLHANDLE                 (RNABASE+27)
#define ERROR_INVALCALLPARAMS                 (RNABASE+28)
#define ERROR_INVALCALLPRIVILEGE              (RNABASE+29)
#define ERROR_INVALCALLSELECT                 (RNABASE+30)
#define ERROR_INVALCALLSTATE                  (RNABASE+31)
#define ERROR_INVALCALLSTATELIST              (RNABASE+32)
#define ERROR_INVALCARD                       (RNABASE+33)
#define ERROR_INVALCOMPLETIONID               (RNABASE+34)
#define ERROR_INVALCONFCALLHANDLE             (RNABASE+35)
#define ERROR_INVALCONSULTCALLHANDLE          (RNABASE+36)
#define ERROR_INVALCOUNTRYCODE                (RNABASE+37)
#define ERROR_INVALDEVICECLASS                (RNABASE+38)
#define ERROR_INVALDEVICEHANDLE               (RNABASE+39)
#define ERROR_INVALDIALPARAMS                 (RNABASE+40)
#define ERROR_INVALDIGITLIST                  (RNABASE+41)
#define ERROR_INVALDIGITMODE                  (RNABASE+42)
#define ERROR_INVALDIGITS                     (RNABASE+43)
#define ERROR_INVALEXTVERSION                 (RNABASE+44)
#define ERROR_INVALGROUPID                    (RNABASE+45)
#define ERROR_INVALLINEHANDLE                 (RNABASE+46)
#define ERROR_INVALLINESTATE                  (RNABASE+47)
#define ERROR_INVALLOCATION                   (RNABASE+48)
#define ERROR_INVALMEDIALIST                  (RNABASE+49)
#define ERROR_INVALMEDIAMODE                  (RNABASE+50)
#define ERROR_INVALMESSAGEID                  (RNABASE+51)
#define ERROR_INVALMODULENAME                 (RNABASE+52)
#define ERROR_INVALPARAM                      (RNABASE+53)
#define ERROR_INVALPARKID                     (RNABASE+54)
#define ERROR_INVALPARKMODE                   (RNABASE+55)
#define ERROR_INVALPOINTER                    (RNABASE+56)
#define ERROR_INVALPRIVSELECT                 (RNABASE+57)
#define ERROR_INVALRATE                       (RNABASE+58)
#define ERROR_INVALREQUESTMODE                (RNABASE+59)
#define ERROR_INVALTERMINALID                 (RNABASE+60)
#define ERROR_INVALTERMINALMODE               (RNABASE+61)
#define ERROR_INVALTIMEOUT                    (RNABASE+62)
#define ERROR_INVALTONE                       (RNABASE+63)
#define ERROR_INVALTONELIST                   (RNABASE+64)
#define ERROR_INVALTONEMODE                   (RNABASE+65)
#define ERROR_INVALTRANSFERMODE               (RNABASE+66)
#define ERROR_LINEMAPPERFAILED                (RNABASE+67)
#define ERROR_NOCONFERENCE                    (RNABASE+68)
#define ERROR_NODEVICE                        (RNABASE+69)
#define ERROR_NODRIVER                        (RNABASE+70)
#define ERROR_NOMEM                           (RNABASE+71)
#define ERROR_NOREQUEST                       (RNABASE+72)
#define ERROR_NOTOWNER                        (RNABASE+73)
#define ERROR_NOTREGISTERED                   (RNABASE+74)
#define ERROR_OPERATIONFAILED                 (RNABASE+75)
#define ERROR_OPERATIONUNAVAIL                (RNABASE+76)
#define ERROR_RATEUNAVAIL                     (RNABASE+77)
#define ERROR_RESOURCEUNAVAIL                 (RNABASE+78)
#define ERROR_REQUESTOVERRUN                  (RNABASE+79)
#define ERROR_STRUCTURETOOSMALL               (RNABASE+80)
#define ERROR_TARGETNOTFOUND                  (RNABASE+81)
#define ERROR_TARGETSELF                      (RNABASE+82)
#define ERROR_UNINITIALIZED                   (RNABASE+83)
#define ERROR_USERUSERINFOTOOBIG              (RNABASE+84)
#define ERROR_REINIT                          (RNABASE+85)
#define ERROR_ADDRESSBLOCKED                  (RNABASE+86)
#define ERROR_BILLINGREJECTED                 (RNABASE+87)
#define ERROR_INVALFEATURE                    (RNABASE+88)

#define RNABASEEND                            (RNABASE+88)

#endif // _RNA_H_
