

typedef HANDLE		HCOLORSPACE;

typedef struct {
DWORD ciexyz_X;
DWORD ciexyz_Y;
DWORD ciexyz_Z;
} CIEXYZ;

typedef struct {
CIEXYZ	ciezyz_Red;
CIEXYZ	ciezyz_Green;
CIEXYZ	ciezyz_Blue;
} CIEXYZTRIPLE;

/*  Logical Color Space Structure */

typedef struct tagLOGCOLORSPACE {
DWORD lcs_version;
DWORD lcs_size;
DWORD lcs_ident;
DWORD lcs_gamut_match;
CIEXYZTRIPLE lcs_endpoints;
DWORD lcs_gamma_red;
DWORD lcs_gamma_green;
DWORD lcs_gamma_blue;
char	lcsFilename[64];
} LOGCOLORSPACE;
typedef LOGCOLORSPACE FAR *LPLOGCOLORSPACE;

BOOL FAR PASCAL EnableICM(HDC, BOOL);
HANDLE FAR PASCAL LoadImageColorMatcher(LPSTR);
BOOL FAR PASCAL FreeImageColorMatcher(HANDLE);
int FAR PASCAL EnumGamutMatchingMethods(HDC,FARPROC,LPARAM);
BOOL FAR PASCAL SetGamutMatchingMethod(HDC,DWORD);
BOOL FAR PASCAL CheckColorsInGamut(HDC,LPVOID,LPVOID,DWORD);
HANDLE FAR PASCAL GetColorSpace(HDC);
BOOL FAR PASCAL GetLogColorSpace(HCOLORSPACE,LPVOID,DWORD);
HCOLORSPACE FAR PASCAL CreateColorSpace(LPLOGCOLORSPACE);
BOOL FAR PASCAL SetColorSpace(HDC,HCOLORSPACE);
BOOL FAR PASCAL DeleteColorSpace(HCOLORSPACE);
BOOL FAR PASCAL GetColorProfile(HDC,LPSTR,WORD);
BOOL FAR PASCAL SetColorProfile(HDC,LPSTR);
BOOL FAR PASCAL GetDeviceGammaRamp(HDC,LPVOID);
BOOL FAR PASCAL SetDeviceGammaRamp(HDC,LPVOID);
BOOL FAR PASCAL ColorMatchToTarget(HDC,HDC,WORD);

#define CS_ENABLE	    1
#define CS_DISABLE	    2
#define CS_DELETE_TRANSFORM 3


/* Menu IDs */


#define IDM_OPEN	100
#define IDM_SAVE	101
#define IDM_PRINT	102
#define IDM_EXIT	103

#define IDM_ENABLEICM		110
#define IDM_GETCOLORSPACE	111
#define IDM_GETLOGCOLORSPACE	112
#define IDM_CREATECOLORSPACE	113
#define IDM_SETCOLORSPACE	114
#define IDM_DELETECOLORSPACE	115
#define IDM_CHECKCOLORS 	116
#define IDM_MATCHTOTARGET	117
#define IDM_ENUMERATEGMM	118
#define IDM_GETGMM		119
#define IDM_SETGMM		120
#define IDM_LOADICM		121
#define IDM_FREEICM		122
#define IDM_GETCOLORPROFILE	123
#define IDM_SETCOLORPROFILE	124
#define IDM_GETGAMMARAMP	125
#define IDM_SETGAMMARAMP	126

#define IDM_CRE_GAMMA_18	302
#define IDM_CRE_GAMMA_22	303
#define IDM_CRE_GBR		304
#define IDM_CRE_GAMMA_18_RBG	305

#define IDM_SET_DEFAULT_CS	310
#define IDM_SET_GAMMA_18	311
#define IDM_SET_GAMMA_22	312
#define IDM_SET_GBR		313
#define IDM_SET_GAMMA_18_RBG	314

#define IDM_DEL_GAMMA_18	321
#define IDM_DEL_GAMMA_22	322
#define IDM_DEL_GBR		323
#define IDM_DEL_GAMMA_18_RBG	324

#define IDM_SGMM_LUM_D		330
#define IDM_SGMM_HUE_D		331
#define IDM_SGMM_SAT_D		332
#define IDM_SGMM_LUM_2		333
#define IDM_SGMM_HUE_2		334
#define IDM_SGMM_SAT_2		335

#define IDM_LOAD_ICM_2		340
#define IDM_LOAD_ICM_3		341
#define IDM_LOAD_ICM_4		342
#define IDM_FREE_ICM_2		343
#define IDM_FREE_ICM_3		344
#define IDM_FREE_ICM_4		345

#define IDM_TEST	140
#define IDM_RGBS	141
#define IDM_PALETTERGBS 142
#define IDM_8BITDIB	143
#define IDM_24BITDIB	144

#define IDM_ABOUT	150
