@echo off

set WinPath=
set DbgPath=
set NoDPath=

rem Place the NoDPath in the parenthesis below
if (%NoDPath%)==() goto ErrorChecking
    rem -----------------------------------
    rem  Display Out of Env. Space Message 
    rem -----------------------------------

    echo:
    echo: Error: Out of Environment Space !!
    echo:
    echo:        Increase the size of your environment using the 
    echo:        '/e' switch on COMMAND.COM.
    echo:        
    echo:        Example CONFIG.SYS:
    echo:
    echo:           SHELL=C:\COMMAND.COM /e:512
    echo:
    goto Done                   
                          
:ErrorChecking                 
    if (%WinPath%)==() goto NoWinPath
    if (%1)==(N) goto NoDebug
    if (%1)==(D) goto Debug
    goto Usage

:NoWinPath
    rem -----------------------------
    rem  Display Set WinPath Message
    rem -----------------------------

    echo:
    echo: Error: Windows System Path not set !!
    echo:
    echo:       Set the  0  environment variable in
    echo:       %0.BAT to your Windows System Directory.
    echo:       Also make sure you have copied NoDebug EXEs
    echo:       to your NoDebug directory (see readme.txt)
    echo:
    goto Done

:Usage
    rem --------------------------  
    rem  Display SWITCH.BAT Usage  
    rem --------------------------

    echo:
    echo: Usage:
    echo:        %0 {N or D}
    echo:
    echo: where  N = switch to nodebug version of windows
    echo:        D = switch to debug version of windows
    echo:
    echo: NOTE: %0 is normally called by N2D & D2N -- please use one of these
    echo:
    goto Done

:Debug
    rem ------------------------     
    rem   Debug Initialization    
    rem ------------------------

    echo Switching to Debug .EXEs, DLLs and .SYMs
    set NoDPath=           
    set ToDir=%DbgPath%
    set DbgPath=         
    set From=N        
    goto SwitchFiles

:NoDebug
    rem ------------------------     
    rem  NoDebug Initialization    
    rem ------------------------

    echo Switching to NoDebug .EXEs, DLLs and .SYMs
    set DbgPath=
    set ToDir=%NoDPath%
    set NoDPath=
    set From=D

:SwitchFiles
    rem ------------------------------------
    rem  Group Loop Variable Initialization
    rem ------------------------------------

    set Grp=GDI

:GroupLoop
    rem -----------------------------------     
    rem  Type Loop Variable Initialization    
    rem -----------------------------------

    set Type=EXE

    :TypeLoop
        echo     %Grp%.%Type%:

        if exist %WinPath%%Grp%%1.%Type%  goto ToFileExists

        rem -----------------------------------  
        rem  Copy file directly to destination  
        rem -----------------------------------

        echo         %ToDir%\%Grp%.%Type%  to  %WinPath%%Grp%.%Type%
        copy %ToDir%\%Grp%.%Type% %WinPath%%Grp%.%Type%
        goto DoneTypeLoop

    :ToFileExists
        if not exist %WinPath%%Grp%.%Type%        goto MoveToFile
        if not exist %WinPath%%Grp%%From%.%Type%  goto MoveDefault

        rem ----------------------------
        rem  Delete file to be replaced
        rem ----------------------------

        del %WinPath%%Grp%.%Type%
        goto MoveToFile

    :MoveDefault
        rem ----------------------------  
        rem  Retain file to be replaced  
        rem ----------------------------

        echo         %WinPath%%Grp%.%Type%  to %WinPath%%Grp%%From%.%Type%
        rename %WinPath%%Grp%.%Type% %Grp%%From%.%Type%
            
    :MoveToFile
        rem ----------------------------  
        rem  Replace file with new file  
        rem ----------------------------

        echo         %WinPath%%Grp%%1.%Type% to %WinPath%%Grp%.%Type%
        rename %WinPath%%Grp%%1.%Type% %Grp%.%Type%

    :DoneTypeLoop                
        rem ----------------------------   
        rem  Advance Type Loop Variable   
        rem ----------------------------

        if %Type%==SYM goto DoneGroupLoop
        if %Type%==EXE set Type=SYM
        goto TypeLoop  
              
    :DoneGroupLoop
    rem -----------------------------  
    rem  Advance Group Loop Variable  
    rem -----------------------------

    if %Grp%==KRNL386 goto SubGroupLoop
    if %Grp%==USER    set Grp=KRNL386
    if %Grp%==GDI     set Grp=USER
    if %Grp%==MMSYSTEM set Grp=GDI
    goto GroupLoop


:SubGroupLoop                              
    rem ----------------------------------------------------------     
    rem  Type Loop Variable Initialization for MMSYSTEM.DLL &.SYM,    
    rem  PENWIN.DLL & .SYM, KERNEL32.DLL & .SYM               
    rem ----------------------------------------------------------

    set Grp=MMSYSTEM
    set Type=DLL

    :SubTypeLoop            
        if (%Grp%.%Type%)==(PENWIN.SYM) goto SubDoneTypeLoop
        echo     %Grp%.%Type%:  

        rem -----------------------------------  
        rem  Copy file directly to destination  
        rem -----------------------------------

        echo         %ToDir%\%Grp%.%Type%  to  %WinPath%%Grp%.%Type%
        copy %ToDir%\%Grp%.%Type% %WinPath%%Grp%.%Type%
        goto SubDoneTypeLoop

    :SubDoneTypeLoop
        rem ----------------------------
        rem  Advance Type Loop Variable
        rem ----------------------------

        if %Type%==SYM goto SubDoneGroupLoop
        if %Type%==DLL set Type=SYM
        goto SubTypeLoop

    :SubDoneGroupLoop
        rem -----------------------------  
        rem  Advance Group Loop Variable  
        rem -----------------------------

        if %Grp%==WINMM    goto Done
        if %Grp%==PENWIN   set Grp=WINMM
        if %Grp%==PENWIN   set Grp=KERNEL32
        if %Grp%==MMSYSTEM set Grp=PENWIN
        set Type=DLL
        goto SubTypeLoop


:Done

set DbgPath=
set From=
set Grp=
set NoDPath=
set ToDir=
set Type=
set WinPath=

