#ifdef CONFIGURATION_FILE
  /* Library Configuration, MRI Internal Use Only */
  #define quote(a) #a
  #define apply(f,s) f(s)
  #include apply(quote, CONFIGURATION_FILE)
#endif

#if !EXCLUDE_s_write
 

/************************************************************************/
/* THIS INFORMATION IS PROPRIETARY TO					*/
/* MICROTEC RESEARCH, INC.						*/
/* 2350 Mission College Blvd.						*/
/* Santa Clara, CA 95054						*/
/* USA									*/
/*----------------------------------------------------------------------*/
/* Copyright (c) Microtec Research, Inc. 1986-91, 1992.			*/
/* All rights reserved.							*/
/************************************************************************/

/*	@(#)s_write.c	1.16 9/15/92	*/

/************************************************************************
*                                                                       *
*  int write (int fd, char *buffer, unsigned nbyte)			*
*                                                                       *
*  write characters to output device					*
*									*
*  write:								*
*	Write "nbyte" characters to output device indicated by the	*
*	file descriptor "fd".  The characters to be written are in	*
*	"buffer".  "fd" is the file descriptor of the device being	*
*	written to.							*
*                                                                       *
*	"Write" returns -1 on error.					*
*                                                                       *
************************************************************************/

#include <stdio.h>
#include <errno.h>
 
/************************************************************************
*       eoln is used to indicate the end of line characters for the     *
*       host system.                                                    *
*                                                                       *
*       eoln =  0       carriage return (13) as end of line, ex :       *
*                       Microtec 68000 simulator                        *
*            =  1       carriage return (13) followed by line feed      *
*                       (10) as end of line, ex : MSDOS, debugger       *
*            =  2       line feed (10) as end of line, ex : UNIX        *
*                                                                       *
************************************************************************/
 
#define eoln 2
 
int write (int fd, char *buffer, unsigned nbyte)
{
    register int cnt= 0;
 
    while (--nbyte != -1) {
#if   eoln == 0
        if (*buffer == '\n') *buffer = '\r';		/* replace by '\r' */
#elif eoln == 1
        if (*buffer == '\n') _OUTCHR('\r');		/* output a '\r' first*/
#endif
        _OUTCHR (*(buffer++));              		/* output one char */
        cnt++;
    }   
    return (cnt);
}
 
#else
	_kill_warning();	/* Eliminates compiler warnings */
#endif /* EXCLUDE_s_write */
 
