
/************************************************************************/
/* THIS INFORMATION IS PROPRIETARY TO					*/
/* MICROTEC RESEARCH, INC.						*/
/* 2350 Mission College Blvd.						*/
/* Santa Clara, CA 95054						*/
/* USA									*/
/*----------------------------------------------------------------------*/
/* Copyright (c) Microtec Research, Inc. 1986-91. All rights reserved. 	*/
/************************************************************************/

/*	@(#)s_sbrk.c	1.5 6/1/92	*/

/************************************************************************/
/*									*/
/*  char *sbrk(int incr);						*/
/*									*/
/*  Allocate memory							*/
/*									*/
/*  sbrk:								*/
/*	Allocates memory, in general for use by heap management		*/
/*	routines.  If successful, sbrk returns the address of the	*/
/*	allocated memory.  If memory is not available, sbrk returns -1. */
/*									*/
/************************************************************************/

#include "s_info.mch"

#pragma option -nOg -nOr -nOr		/* Turn off -O option */

char *sbrk(unsigned incr)
{
	char *oldBreak, *newBreak;

	oldBreak = _HEAP;		/* current upper limit of heap */
	if (incr) {
		newBreak = oldBreak + incr;
		if ((newBreak > (_HEAP_START + _HEAP_SIZE)) /* out of space ? */
			|| (newBreak <= _HEAP_START))       /* memory wrap ? */
		    return (char *) (-1);
		_HEAP = newBreak;
	}
	return oldBreak;
}
