#ifdef CONFIGURATION_FILE
  /* Library Configuration, MRI Internal Use Only */
  #define quote(a) #a
  #define apply(f,s) f(s)
  #include apply(quote, CONFIGURATION_FILE)
#endif
 
#if !EXCLUDE_s_read
 

/************************************************************************/
/* THIS INFORMATION IS PROPRIETARY TO					*/
/* MICROTEC RESEARCH, INC.						*/
/* 2350 Mission College Blvd.						*/
/* Santa Clara, CA 95054						*/
/* USA									*/
/*----------------------------------------------------------------------*/
/* Copyright (c) Microtec Research, Inc. 1986-91, 1992.			*/
/* All rights reserved.							*/
/************************************************************************/

/*	@(#)s_read.c	1.15 9/15/92	*/

/************************************************************************
*                                                                       *
*  int read (int fd, char *buffer, unsigned nbyte)			*
*                                                                       *
*  read characters from input device					*
*									*
*  read:								*
*	Read "nbyte" characters from the file indicated by the 		*
*	file descriptor "fd".  These characters are placed in the	*
*	buffer pointed to by "buffer".					*
*                                                                       *
*	"Read" returns the number of bytes actually read.  If input	*
*	is occurring from a terminal, "read" will read at most one line	*
*	of input.  If an error occurs "read" returns a -1.  If end of	*
*	file occurs, "read" returns 0.					*
*                                                                       *
************************************************************************/

#include <stdio.h>
#include <errno.h>

/************************************************************************
*	eoln is used to indicate the end of line characters for the	*
*	host system.							*
*									*
*	eoln =  0	carriage return (13) as end of line, ex :	*
*			Microtec 68000 simulator			*
*	     =  1	carriage return (13) followed by line feed	*
*			(10) as end of line, ex : MSDOS, debugger	*
*	     =  2	line feed (10) as end of line, ex : UNIX	*
*									*
************************************************************************/

#define eoln 2	

int read (int fd, char *buffer, unsigned nbyte)
{
    register int cnt=0, ch;
    char _INCHRW ();			/* get one character from input */
 
    while (--nbyte != -1) {
        if ((ch = _INCHRW()) == -1) {    /* read in one char */
            errno = EIO;
            return (-1);
        }   
#if   eoln == 1
        if (ch == '\r') continue;	/* skip carriage return */
#elif eoln == 0
        if (ch == '\r') ch = '\n';	/* replace '\r' by '\n' */
#endif
        *(buffer++) = ch;
        cnt++;
        if (ch == '\r' || ch == '\n')   /* CR or LF terminates the read */
            break;
    }
    return (cnt);
}
 
#else
	_kill_warning();	/* Eliminates compiler warnings */
#endif /* EXCLUDE_s_read */
 
