#ifdef CONFIGURATION_FILE
  /* Library Configuration, MRI Internal Use Only */
  #define quote(a) #a
  #define apply(f,s) f(s)
  #include apply(quote, CONFIGURATION_FILE)
#endif
 
#if !EXCLUDE_s_open
 

/************************************************************************/
/* THIS INFORMATION IS PROPRIETARY TO					*/
/* MICROTEC RESEARCH, INC.						*/
/* 2350 Mission College Blvd.						*/
/* Santa Clara, CA 95054						*/
/* USA									*/
/*----------------------------------------------------------------------*/
/* Copyright (c) Microtec Research, Inc. 1986-91, 1992.			*/
/* All rights reserved.							*/
/************************************************************************/

/*	@(#)s_open.c	1.9 9/15/92 */

/************************************************************************
*                                                                       *
*  int open (char *filename, int flags, int mode);			*
*                                                                       *
*  open file								*
*                                                                       *
*  int open(filename, flags, mode) char *filename; int flags, mode;	*
*	Opens the specified file, depending on the indicated type,	*
*	the types are as follows:					*
*									* 
*	O_RDONLY        0x0000          open for read only		*
*	O_WRONLY        0x0001          open for write only		*
*	O_RDWR          0x0002          open for read and write		*
*	O_APPEND        0x0008          writes performed at EOF		*
*	O_CREAT         0x0200          create file			*
*	O_TRUNC         0x0400          truncate file			*
*	O_FORM          0x4000          text file			*
*	O_BINARY        0x8000          binary file			*
*									* 
*	The value of mode is always set to 0744 for UNIX compatibility.	*
*	Open should return a file descriptor (or "file handle") for	*
*	the file it opens.  On failure it should return -1.		*
*									* 
************************************************************************/

#define O_RDONLY        0x0000          /* open for reading only */
#define O_WRONLY        0x0001          /* open for writing only */
#define O_RDWR          0x0002          /* open for reading and writing */
#define O_APPEND        0x0008          /* writes performed at end of file */
#define O_CREAT         0x0200          /* create file if necessary */
#define O_TRUNC         0x0400          /* truncate file */
#define O_FORM          0x4000          /* text file */
#define O_BINARY        0x8000          /* binary file */

int open (filename, flags, mode)
char *filename;
int  flags;
int  mode;
{
#if !(_MCC68K || _MCCSP || _MCC29K || _MCCG32 || _MCC88K)
    extern  _WARNING_open_stub_used();	/* generate error at link time */
    int (* volatile stub)() = _WARNING_open_stub_used;

    _rtl_stub_msg("open");	/* generate run-time error if stub used */
#endif

    return 0;			/* open returns a file handle */
}
 
#else
	_kill_warning();	/* Eliminates compiler warnings */
#endif /* EXCLUDE_s_open */
 
