#ifdef CONFIGURATION_FILE
  /* Library Configuration, MRI Internal Use Only */
  #define quote(a) #a
  #define apply(f,s) f(s)
  #include apply(quote, CONFIGURATION_FILE)
#endif
 
#if !EXCLUDE_s_lseek
 

/************************************************************************/
/* THIS INFORMATION IS PROPRIETARY TO					*/
/* MICROTEC RESEARCH, INC.						*/
/* 2350 Mission College Blvd.						*/
/* Santa Clara, CA 95054						*/
/* USA									*/
/*----------------------------------------------------------------------*/
/* Copyright (c) Microtec Research, Inc. 1986-91, 1992.			*/
/* All rights reserved.							*/
/************************************************************************/

/*	@(#)s_lseek.c	1.8 9/15/92	*/

/****************************************************************************/
/*									    */
/*  long lseek (int fd, long offset, int whence);			    */
/*									    */
/*  Reposition file							    */
/*									    */
/*  lseek:								    */
/*	Positions the file indicated by the file descriptor "fd" to the	    */
/*	location indicated by "offset" and "whence".  If "whence" is 0, then*/
/*	"offset" is taken to be relative to the beginning of the file.  If  */
/*	"whence" is 1, then "offset" is taken to be relative to the current */
/*	file position.  If "whence" is 2, then "offset" is taken to be	    */
/*	relative to the end of file.  If an error occurs, lseek returns	    */
/*	-1.								    */
/*									    */
/****************************************************************************/

#include	<stdio.h>

long lseek (int fd, long offset, int whence)
	{
#if !(_MCC68K || _MCCSP || _MCC29K || _MCCG32 || _MCC88K)
	extern  _WARNING_lseek_stub_used();
	int (* volatile stub)() = _WARNING_lseek_stub_used;

	_rtl_stub_msg("lseek");
#endif
	return 0;
	}
 
#else
	_kill_warning();	/* Eliminates compiler warnings */
#endif /* EXCLUDE_s_lseek */
 
