#ifdef CONFIGURATION_FILE
  /* Library Configuration, MRI Internal Use Only */
  #define quote(a) #a
  #define apply(f,s) f(s)
  #include apply(quote, CONFIGURATION_FILE)
#endif
 
#if !EXCLUDE_s_exit
 

/************************************************************************/
/* THIS INFORMATION IS PROPRIETARY TO					*/
/* MICROTEC RESEARCH, INC.						*/
/* 2350 Mission College Blvd.						*/
/* Santa Clara, CA 95054						*/
/* USA									*/
/*----------------------------------------------------------------------*/
/* Copyright (c) Microtec Research, Inc. 1986-91, 1992.			*/
/* All rights reserved. 						*/
/************************************************************************/

/*	@(#)s_exit.c	1.7 9/15/92	*/

/************************************************************************
*                                                                       *
*  void exit (code) int code;						*
*                                                                       *
*  terminate C program							*
*                                                                       *
*  _exit_abort:								*
*	Flushes and closes all open files then calls _exit() using	*
*	"val" as the argument.  Does not return.			*
*									*
*	This routine is called by exit () and is the final call in the	*
*	default raise (SIGABRT) code and the abort () functions		*
*									*
*  exit:								*
*	Executes all functions specified in atexit () function calls.	*
*	Executes C++ destructors.  Then calls _exit_abort () described	*
*	above.								*
*									* 
*  									*
*  NOTE:								*
*	The call to _atexit_functs () may be removed if atexit () is	*
*	never called in the user's program.				*
*									*
*	The function _cxxfini () executes the static destructors for	*
*	C++.  If C++ is not being used, this function call may be	*
*	removed.							*
*									*
*	The "for" loop which executes fclose () on all streams may be	*
*	removed if no buffered i/o is performed.  The function fclose ()*
*	causes free () to be linked in.					*
************************************************************************/

#include <stdio.h>

void _exit_abort (val)
int val;
{
    register int i;

    for (i=0; i < FOPEN_MAX; i++)		/* close all open streams */
        if (_iob[i]._flag & (_IOREAD|_IOWRT))	/* may be removed if no */
	    fclose (&_iob[i]);			/* buffered i/o is performed */

    _exit(val);
}

void exit (val)
int val;
{
 
    _atexit_functs ();          /* execute functions saved by atexit        */
                                /* may be removed if atexit is never called */
    _cxxfini ();		/* execute static destructors for c++ */
                                /* may be removed if c++ is not being used */
    _exit_abort (val);		/* finish up by closing streams and */
				/* calling _exit */
}
 
#else
	_kill_warning();	/* Eliminates compiler warnings */
#endif /* EXCLUDE_s_exit */
 
