#ifdef CONFIGURATION_FILE
  /* Library Configuration, MRI Internal Use Only */
  #define quote(a) #a
  #define apply(f,s) f(s)
  #include apply(quote, CONFIGURATION_FILE)
#endif
 
#if !EXCLUDE_s_creat
 

/************************************************************************/
/* THIS INFORMATION IS PROPRIETARY TO					*/
/* MICROTEC RESEARCH, INC.						*/
/* 2350 Mission College Blvd.						*/
/* Santa Clara, CA 95054						*/
/* USA									*/
/*----------------------------------------------------------------------*/
/* Copyright (c) Microtec Research, Inc. 1986-91, 1992.			*/
/* All rights reserved.							*/
/************************************************************************/

/*	@(#)s_creat.c	1.6 9/15/92	*/

/************************************************************************
*                                                                       *
*  int creat (filename, prot) char *filename, int prot;			*
*                                                                       *
*  open file, create file if necessary					*
*                                                                       *
*  creat:								*
*	Creates and opens (for writing) a file named filename with	*
*	protection as specified by prot.  For things like terminals	*
*	that cannot be created it should just open the device.  Creat	*
*	should return a file descriptor (or "file handle") for the	*
*	file it opens.  On failure it should return -1.			*
*									* 
************************************************************************/

#define		O_WRONLY	0x0001		/* open for write only */
#define		O_CREAT		0x0200		/* create file */
#define		O_TRUNC		0x0400		/* truncate file */
#define		O_FORM		0x4000		/* text file */

creat (filename, mode)
char *filename;
int mode;
{
    return (open (filename, O_WRONLY | O_CREAT | O_TRUNC | O_FORM, mode));
}
 
#else
	_kill_warning();	/* Eliminates compiler warnings */
#endif /* EXCLUDE_s_creat */
 
