
/************************************************************************/
/* Copyright (c) 1988-1991 Microtec Research, Inc.			*/
/* ALL RIGHTS RESERVED							*/
/************************************************************************/

/*  <stdlib.h>	Microtec Research, Inc. ANSI C Compiler  */
/* @(#)stdlib.h	1.15 12/3/91 */

#ifndef __STDLIB_H
#define __STDLIB_H

#if __STDC__
    typedef unsigned char wchar_t;

    #ifdef _sun
	typedef int size_t;
    #else
	typedef unsigned size_t;
    #endif
#endif /* __STDC__ */

typedef struct div_t {int  quot, rem;} div_t;
typedef struct ldiv_t {long quot, rem;} ldiv_t;

#define EXIT_FAILURE	1
#define EXIT_SUCCESS	0
#define RAND_MAX	0x7FFF
#define MB_CUR_MAX	1

#if __cplusplus
    #define	NULL		(0)
#else
    #define	NULL		((void *)0)
#endif


#if _FPU		/* Convert functions to '881 versions */
    #undef	atof
    #undef	strtod
    #define	atof	_atof881
    #define	strtod	_strtod881
#endif	/* _FPU */

#if _68040		/* Convert functions to '040 versions */
    #undef	atof
    #undef	strtod
    #define	atof	_atof040
    #define	strtod	_strtod040
#endif	/* _68040 */

#if __STDC__

    #if __cplusplus
	extern "C" {
    #endif

    extern double    atof(const char *);
    extern int       atoi(const char *);
    extern long      atol(const char *);
    extern double    strtod(const char *, char **);
    extern long      strtol(const char *, char **, int);
    extern unsigned  long strtoul(const char *, char **, int);
    extern int       rand(void);
    extern void      srand(unsigned);
    extern void     *calloc(size_t, size_t);
    extern void      free(void *);
    extern void     *malloc(size_t);
    extern void     *realloc(void *, size_t);
    extern void      abort(void);
    extern int       atexit(void (*)(void));
    extern void      exit(int);
    extern char     *getenv(const char *);
    extern int       system(const char *);
    extern void     *bsearch(const void *, const void *, size_t,
			size_t, int (*)(const void *, const void *));
    extern void      qsort(void *, size_t, size_t,
			int (*)(const void *, const void *));
    extern int       abs(int);
    extern div_t     div(int, int);
    extern long      labs(long);
    extern ldiv_t    ldiv(long, long);
    extern int       mblen(const char *, size_t);
    extern int       mbtowc(wchar_t *, const char *, size_t);
    extern int       wctomb(char *, wchar_t);
    extern size_t    mbstowcs(wchar_t *, const char *, size_t);
    extern size_t    wcstombs(char *, const wchar_t *, size_t);

    #if __cplusplus
	}
    #endif

#else /* __STDC__ */

    extern double    atof();
    extern int       atoi();
    extern long      atol();
    extern double    strtod();
    extern long      strtol();
    extern unsigned  long strtoul();
    extern int       rand();
    extern void      srand();
    extern void     *calloc();
    extern void      free();
    extern void     *malloc();
    extern void     *realloc();
    extern void      abort();
    extern int       atexit();
    extern void      exit();
    extern char     *getenv();
    extern int       system();
    extern void     *bsearch();
    extern void      qsort();
    extern int       abs();
    extern div_t     div();
    extern long      labs();
    extern ldiv_t    ldiv();
    extern int       mblen();
    extern int       mbtowc();
    extern int       wctomb();
    extern int	     mbstowcs();
    extern int	     wcstombs();

#endif	/* ! __STDC__ */

#endif /* end __STDLIB_H */
