
/************************************************************************/
/* Copyright (c) 1988-1991, 1992 Microtec Research, Inc.                */
/* ALL RIGHTS RESERVED							*/
/************************************************************************/
/*  <mriext.h>  Microtec Research, Inc. ANSI C Compiler  */
/* @(#)mriext.h	1.32 7/21/92 */

#ifndef __MRIEXT_H
#define __MRIEXT_H

#include <stddef.h>	/* define the type "size_t" used in this header */
#include <stdio.h>	/* define the type "FILE"   used in this header */

/************************************************************************/
/*		Microtec extensions to <ctype.h>			*/
/************************************************************************/

#undef isascii
#undef toascii
#undef _tolower
#undef _toupper

#if __STDC__

    #if __cplusplus
	extern "C" {
    #endif

    extern int isascii(int);
    extern int toascii(int);
    extern int _tolower(int);
    extern int _toupper(int);

    #if __cplusplus
	}
    #endif

#else /* ! __STDC__ */

    extern int isascii();
    extern int toascii();
    extern int _tolower();
    extern int _toupper();

#endif /* ! __STDC__ */

#define isascii(c) ((unsigned)(c)<=0x7F)
#define toascii(c) ((c)&0x7F)
#define _tolower(c) ((c)+('a'-'A'))
#define _toupper(c) ((c)+('A'-'a'))

#undef	 max
#define  max(a,b)	(((a) > (b)) ? (a) : (b))
#undef	 min
#define  min(a,b)	(((a) < (b)) ? (a) : (b))

/************************************************************************/
/*		Microtec extensions to <stdio.h>			*/
/************************************************************************/

#undef	BLKSIZE
#undef	NULLPTR
#undef	TRUE
#undef	FALSE

#define BLKSIZE	BUFSIZ
#define NULLPTR ((char *)0)
#define	TRUE	1
#define	FALSE	0

#undef	stdaux
#undef	stdprn
#undef	fileno

#define	stdaux		(&_iob[3])
#define	stdprn		(&_iob[4])
#define	fileno(f)	((f)->_file)

#if _FPU
    #undef	eprintf
    #define	eprintf	_eprintf881
#endif

#if _68040
    #undef	eprintf
    #define	eprintf	_eprintf040
#endif

#if __STDC__

    #if __cplusplus
	extern "C" {
    #endif

    extern int  eprintf (const char *, ...);
    extern long getl (FILE *);
    extern int  getw (FILE *);
    extern long putl (long, FILE *);
    extern int  putw (int, FILE *);

    #if __cplusplus
	}
    #endif

#else	/* ! __STDC__ */
    extern int  eprintf ();
    extern long getl ();
    extern int  getw ();
    extern long putl ();
    extern int  putw ();
#endif

/************************************************************************/
/*		Microtec extensions to <stdlib.h>			*/
/************************************************************************/

#if __STDC__

    #if _FPU		/* Convert function to '881 versions */
	#undef	ftoa
	#define	ftoa	_ftoa881
    #endif /* _FPU */

    #if _68040		/* Convert function to '040 versions */
	#undef	ftoa
	#define	ftoa	_ftoa040
    #endif /* _FPU */

    #if __cplusplus
	extern "C" {
    #endif

    extern int	ftoa(double, char *, int, int);
    extern int	itoa(int, char *);
    extern int	itostr(unsigned, char *, int);
    extern int	ltoa(long, char *);
    extern int	ltostr(unsigned long, char *, int);
    extern void	swab(char *, char *, int);
    extern void	*zalloc(size_t);

    #if __cplusplus
	}
    #endif

#else /* ! __STDC__ */

    extern int	ftoa();
    extern int	itoa();
    extern int	itostr();
    extern int	ltoa();
    extern int	ltostr();
    extern void	swab();
    extern void	*zalloc();

#endif /*! __STDC__ */

/************************************************************************/
/*		Microtec extensions to <string.h>			*/
/************************************************************************/

#if __STDC__

    #if __cplusplus
	extern "C" {
    #endif

    extern char   *memccpy (char *, const char *, int, size_t);
    extern char   *memclr (char *, size_t);

    #if __cplusplus
	}
    #endif

#else /* ! __STDC__ */

    extern char   *memccpy ();
    extern char   *memclr ();

#endif /* ! __STDC__ */

#endif /* end __MRIEXT_H */
