
/************************************************************************/
/* Copyright (c) 1988-1991  Microtec Research, Inc.			*/
/* ALL RIGHTS RESERVED							*/
/************************************************************************/
/*  <mathf.h>	Microtec Research, Inc. ANSI C Compiler  */
/* @(#)mathf.h	1.20 11/9/92 */

#ifndef __MATHF_H
#define __MATHF_H	1

#undef	HUGE_VAL

#define HUGE_VAL 1.7976931348623155E+308 /* approx. largest F.P. number */

#if _FPU || _68040

    #if _FPU		/* Convert math functions to '881 versions */

	#undef	atan2
	#undef	ceil
	#undef	floor
	#undef	frexp
	#undef	ldexp
	#undef	modf
	#undef	pow
	#undef	fmod

	#define	atan2	_atan2881
	#define ceil	_ceil881
	#define floor	_floor881
	#define	frexp	_frexp881
	#define ldexp	_ldexp881
	#define modf	_modf881
	#define	pow	_pow881
	#define	fmod	_fmod881

        #if !_MRI_EXTENSIONS  /* hardware available, but no inlining */

	    #undef acos
	    #undef asin
	    #undef atan
	    #undef cos
	    #undef sin
	    #undef tan
	    #undef cosh
	    #undef sinh
	    #undef tanh
	    #undef exp
	    #undef log
	    #undef log10
	    #undef sqrt
	    #undef fabs

	    #define acos	_acos881
	    #define asin	_asin881
	    #define atan	_atan881
	    #define cos		_cos881
	    #define sin		_sin881
	    #define tan		_tan881
	    #define cosh	_cosh881
	    #define sinh	_sinh881
	    #define tanh	_tanh881
	    #define exp		_exp881
	    #define log		_log881
	    #define log10	_log10881
	    #define sqrt	_sqrt881
	    #define fabs	_fabs881

	#endif  /* ! _MRI_EXTENSIONS */

    #else	/* ! _FPU  (_68040) */

	#undef acos
	#undef asin
	#undef atan
	#undef atan2
	#undef cos
	#undef sin
	#undef tan
	#undef cosh
	#undef sinh
	#undef tanh
	#undef exp
	#undef frexp
	#undef ldexp
	#undef log
	#undef log10
	#undef modf
	#undef pow
	#undef ceil
	#undef floor
	#undef fmod

	#define acos	_acos040
	#define asin	_asin040
	#define atan	_atan040
	#define atan2	_atan2040
	#define cos	_cos040
	#define sin	_sin040
	#define tan	_tan040
	#define cosh	_cosh040
	#define sinh	_sinh040
	#define tanh	_tanh040
	#define exp	_exp040
	#define frexp	_frexp040
	#define ldexp	_ldexp040
	#define log	_log040
	#define log10	_log10040
	#define modf	_modf040
	#define pow	_pow040
	#define ceil	_ceil040
	#define floor	_floor040
	#define fmod	_fmod040

        #if !_MRI_EXTENSIONS  /* hardware available, but no inlining */

	    #undef sqrt
	    #undef fabs

	    #define sqrt	_sqrt881
	    #define fabs	_fabs881

	#endif  /* ! _MRI_EXTENSIONS */

    #endif	/* ! _FPU  (_68040) */

    #if __STDC__

	#if __cplusplus
	    extern "C" {
	#endif

	extern double acos(double);
	extern double asin(double);
	extern double atan(double);
	extern double atan2(double, double);
	extern double cos(double);
	extern double sin(double);
	extern double tan(double);
	extern double cosh(double);
	extern double sinh(double);
	extern double tanh(double);
	extern double exp(double);
	extern double frexp(double, int *);
	extern double ldexp(double, int);
	extern double log(double);
	extern double log10(double);
	extern double modf(double, double *);
	extern double pow(double, double);
	extern double sqrt(double);
	extern double ceil(double);
	extern double fabs(double);
	extern double floor(double);
	extern double fmod(double, double);

	#if __cplusplus
	    }
	#endif

    #else /* !__STDC__ */

	extern double acos();
	extern double asin();
	extern double atan();
	extern double atan2();
	extern double cos();
	extern double sin();
	extern double tan();
	extern double cosh();
	extern double sinh();
	extern double tanh();
	extern double exp();
	extern double frexp();
	extern double ldexp();
	extern double log();
	extern double log10();
	extern double modf();
	extern double pow();
	extern double sqrt();
	extern double ceil();
	extern double fabs();
	extern double floor();
	extern double fmod();

    #endif /* __STDC__ */

#else	/* ! _68040 && ! _FPU */

    #if __STDC__

	#undef	acos
	#undef	asin
	#undef	atan
	#undef	atan2
	#undef	cos
	#undef	sin
	#undef	tan
	#undef	cosh
	#undef	sinh
	#undef	tanh
	#undef	exp
	#undef	frexp
	#undef	ldexp
	#undef	log
	#undef	log10
	#undef	modf
	#undef	pow
	#undef	sqrt
	#undef	ceil
	#undef	fabs
	#undef	floor
	#undef	fmod

	#define	acos	acosf
	#define	asin	asinf
	#define	atan	atanf
	#define	atan2	atan2f
	#define	cos	cosf
	#define	sin	sinf
	#define	tan	tanf
	#define	cosh	coshf
	#define	sinh	sinhf
	#define	tanh	tanhf
	#define	exp	expf
	#define	frexp	frexpf
	#define	ldexp	ldexpf
	#define	log	logf
	#define	log10	log10f
	#define	modf	modff
	#define	pow	powf
	#define	sqrt	sqrtf
	#define	ceil	ceilf
	#define	fabs	fabsf
	#define	floor	floorf
	#define	fmod	fmodf

	#if __cplusplus
	    extern "C" {
	#endif

	extern float	acosf(float);
	extern float	asinf(float);
	extern float	atanf(float);
	extern float	atan2f(float, float);
	extern float	cosf(float);
	extern float	sinf(float);
	extern float	tanf(float);
	extern float	coshf(float);
	extern float	sinhf(float);
	extern float	tanhf(float);
	extern float	expf(float);
	extern float	frexpf(float, int *);
	extern float	ldexpf(float, int);
	extern float	logf(float);
	extern float	log10f(float);
	extern float	modff(float, float *);
	extern float	powf(float, float);
	extern float	sqrtf(float);
	extern float	ceilf(float);
	extern float	fabsf(float);
	extern float	floorf(float);
	extern float	fmodf(float, float);

	#if __cplusplus
	    }
	#endif

    #else /* !__STDC__ */

	extern double acos();
	extern double asin();
	extern double atan();
	extern double atan2();
	extern double cos();
	extern double sin();
	extern double tan();
	extern double cosh();
	extern double sinh();
	extern double tanh();
	extern double exp();
	extern double frexp();
	extern double ldexp();
	extern double log();
	extern double log10();
	extern double modf();
	extern double pow();
	extern double sqrt();
	extern double ceil();
	extern double fabs();
	extern double floor();
	extern double fmod();

    #endif /* __STDC__ */

#endif	/* ! _68040 && ! _FPU */

#endif /* end __MATHF_H */
