/****************************************************************************/
/* THIS INFORMATION IS PROPRIETARY TO                                       */
/* MICROTEC RESEARCH, INC.                                                  */
/*--------------------------------------------------------------------------*/
/* Copyright (c) 1987, 1988, 1989, 1990, 1991, 1992 Microtec Research, Inc. */
/* All rights reserved                                                      */
/****************************************************************************/
/*	3/27/92 @(#)initcopy.c	1.1	*/

/****************************************************************************
*
* Title		INITCOPY.C
*
* Abstract	Initialization routine to copy the initialized data to RAM  
*		space based on organized information stored in the special
*		section assigned through linker command INITDATA. 
*
* Functions	This routine will scan thorugh the section ??INITDATA and copy
*		data based on the special bytes indicated.  The content of
*		this section consists the content of each individual input
*		section specified in INITDATA command (i.e. even sections
*		are specified as output section).  Special bytes are:
*		Byte 'S' means the starting of a section;
*		Byte 'C' means operation COPY;
*		Byte 'E' meand end of section;
*		Four bytes after byte 'C' indicates the size of section;
*		Subsequent four bytes that follows indicates the address 
*		of copy destination.
* Returns	0 - Normal return
*		1 - ??INITDATA not initialized - No starting point
*		2 - ??INITDATA not initialized correctly - Unknown operation
*
* Preprocessor	_A5_REL	Set this preprocessor symbol whenever A5 relative
* Symbols		addressing is used.  This should be used for both
*			single and multi-threaded applications.
*
*		_PC_REL	Set this preprocessor symbol whenever pc-relative
*			data addressing is used.
*
*		Neither of the two above symbols should be set when using
*		absolute data addressing.
*
****************************************************************************/

#include <string.h>

#if	_A5_REL		/* Compute memory "distance" which data has moved */
    #define TARGET	(dest \
			+ asm (unsigned long, \
			"	xref		?A5", \
			"	move.l		a5,d0",		/* run-time */ \
			"	sub.l		#?A5,d0"))	/* link-time */
#elif	_PC_REL		
    static const unsigned long address = (const unsigned long) &address;
    #define TARGET	(dest \
			+ (unsigned long) &address	/* run-time address */ \
			- address)			/* link-time address */
#else
    #define TARGET      (dest)		/* assume absolute data addressing */
#endif


int	_initcopy()
{
  register char 	*local;
  register unsigned 	long size, dest;
  
  if (ASM (unsigned, "\tmove.l\t#.sizeof.(??INITDATA),d0") <= 2)
    return 0;		/* if ??INITDATA is empty -- return w. no error */

  local = (char *) ASM("\tmove.l\t#.startof.(??INITDATA),d0");

  if (*local != 'S')
       return 1;

  local++;
  while (*local != 'E')
       {
       switch (*local)
	 {
	 case 'C':
	   local++;
	   size = (unsigned long)(((unsigned char)*local << 24) |
			     ((unsigned char)*(local+1) << 16) |
			     ((unsigned char)*(local+2) << 8) |
			     (unsigned char)*(local+3));
	   local += 4;
	   dest = (unsigned long)(((unsigned char)*local << 24) |
			     ((unsigned char)*(local+1) << 16) |
			     ((unsigned char)*(local+2) << 8) |
			     (unsigned char)*(local+3));
	   local += 4;
	   memcpy ((void *) TARGET, (void *) local, (size_t) size);
	   local += size;
	   break;
	 default:
	   return 2;
	 }
       }
  return 0;					/* Normal return */
}
