/*
; ----------------------------------------------------------------------------
; THIS INFORMATION IS PROPRIETARY TO
; MICROTEC RESEARCH, INC.
; 2350 Mission College Blvd.
; Santa Clara, CA 95054
; USA
; ----------------------------------------------------------------------------
; Copyright (c) 1992  Microtec Research, Inc.
; All Rights Reserved
; ----------------------------------------------------------------------------
*/
/*******************************************************************/ 
/*                                                                 */ 
/*    INCHRW()  : Input routine which called by READ in CSYS68K    */ 
/*                                                                 */ 
/*    note: check HP manual                                        */ 
/*          "68000/68008 Emulation with Internal Analsys"          */ 
/*          chapter 9 to 13 for more details                       */ 
/*								   */ 
/*******************************************************************/ 
  
  
#define PRINTER 1      /* keyword for 64000 simulated I/O */
#define DISPLAY 2 
#define DISC    3 
#define KEYBOARD 4
#define TRUE 1
#define FALSE 0

static int KFILE_OPEN = FALSE;
  
extern char KEY_CNTL_0,     /* control address for keyboard I/O */
	    KEY_CNTL_1[];
  
char INCHRW() 
{ 
	if(KFILE_OPEN  == FALSE)
	{
		KEY_CNTL_1[0] = 0;  /* read only option */
		KEY_CNTL_1[1] = 19; /* set char count */
		strcpy(&KEY_CNTL_1[2],"/dev/simio/keyboard");
		KEY_CNTL_0 = 0x90;  /* issue open */
    		KFILE_OPEN = TRUE;
		WaIt(KEYBOARD);
	}	
     KEY_CNTL_1[1] = 1;     /* input one character */ 
     KEY_CNTL_0 = 0x92;     /* read the keyboard */ 
     WaIt(KEYBOARD);        /* wait for response */ 
     return(KEY_CNTL_1[3]); /* return one character */ 
} 
