#ifdef CONFIGURATION_FILE
  /* Library Configuration, MRI Internal Use Only */
  #define quote(a) #a
  #define apply(f,s) f(s)
  #include apply(quote, CONFIGURATION_FILE)
#endif

#if EXCLUDE_entry
  #pragma option -Qws      /* Eliminates compiler warnings */
#else
/************************************************************************/
/* THIS INFORMATION IS PROPRIETARY TO					*/
/* MICROTEC RESEARCH, INC.						*/
/*----------------------------------------------------------------------*/
/* Copyright (c) 1991, 1992 Microtec Research, Inc.                     */
/* All rights reserved							*/
/************************************************************************/

/************************************************************************/
/*       	                                                     	*/
/*  ENTRY:  This is the main entry point routine, it does the following	*/
/*									*/
/*          1. Initializes SP as (.startof.(stack) + .sizeof.(stack))	*/
/*	       (defined at link time)				        */
/*	    2. Initializes __HEAP as starting address of SECTION heap   */
/*          3. Initializes the frame pointer to zero for debugger	*/
/*	    4. Clears SECTION zerovars  				*/
/*          5. Calls C initialization routine _START			*/
/*									*/
/*	This module also contains the following functions:		*/
/*	          _exit():  Called by exit() upon program termination	*/
/*	 __enable_cache():  Application specific function provided by   */
/*			    user 					*/
/*									*/
/************************************************************************/
/*									*/
/*	note:   The special character "%" which appears after 		*/
/*		some of the comment indicators indicates code which	*/
/*		might be used in an environment requiring perfectly	*/
/*		reentrant libraries.					*/
/*	        							*/
/*		The "%" must be removed if the comment indicator	*/
/*		is removed.  It may be used to aid the user in 		*/
/*		modifying this routine for special applications.	*/
/*									*/
/*		     This code:						*/
/*			1.  Allocates memory for library static memory	*/
/*			    (554 bytes) and stack for one task.		*/
/*			2.  Zeros appropriate memory in the allocated	*/
/*			    A5 relative memory.				*/
/*			3.  Zeros SECTION userzero which might	        */
/*			    contain uninitialized static data	        */
/*			    for all user tasks.				*/
/*									*/
/*		     Also, the user must:				*/
/*			1.  Execute initialization of __HEAP only	*/
/*			    once, preferably in the kernel.		*/
/*			2.  Disable interrupts while code which		*/
/*			    allocates data and stack space is executing.*/
/*			3.  Disable interrupts whenever the routine	*/
/*			    sbrk() is running.				*/
/*			4.  Modify the linker command file   		*/
/*			    appropriately.				*/
/*		     How interrupts are disabled for 2. and 3. above is	*/
/*		     left to the user.					*/
/*									*/
/*		     Please see the section "Multi-Tasking Environments"*/
/*		     in the chapter "Embedded Environments" in the	*/
/*		     "MCC68K Reference Manual" for more detail.	 Note 	*/
/*		     that the sample code in this file corresponds most */
/*		     closely to the approach described in		*/
/*		     "Multi-Tasking Environments" as opposed to		*/
/*		     "Multi-Tasking Environments - a Second Approach".	*/
/*									*/
/*		     The user must also manually remove the statement	*/
/*									*/
/*			MOVE.L   #?A5,A5   * A5 LIBRARY INITIALIZATION	*/
/*									*/
/*		     if either of the two above approaches is used.	*/
/************************************************************************/
           
/*	@(#)entry.c	1.21 11/24/92	*/

#include <string.h>		/* DECLARATIONS TO ELIMINATE COMPILER WARNING */

#if _PIC			/* SET BY COMPILER */
    #if _68020 || _68030 || _68040 || _CPU32
	#define ADDR(x) (x).L(PC)
    #else
	#define ADDR(x) (x).W(PC)
    #endif
#else
    #define ADDR(x)     (x)
#endif	/* _PIC */
#pragma asm
              OPT	CASE
	      COMMON	stack,,D	    * DECLARE stack SECTION
              SECTION   code,,C		    * CODE SECTION
	      XDEF	ENTRY
	      XDEF	__exit
*
              XREF      __START
              XREF      _exit
              XREF      _memset
#if ! _STR_CMP (_PID_REG, "A5")
	      XREF	?A5
#endif
*
ENTRY:	      LEA.L	.STARTOF.(stack)+.SIZEOF.(stack),SP
						* INITIALIZE STACK POINTER TO -
						* BE POSITION INDEPENDENT
	      MOVE.L	__PC_LABEL,D0		* LINK TIME PC
	      LEA.L	__PC_LABEL(PC),A0	* RUN-TIME PC
	      SUB.L	A0,D0			* GET PC DIFFERENCE IF CHANGED
	      SUB.L	D0,SP			* ADJUST STACK POINTER

	      LEA.L     __HEAP,A0	        * INITIALIZE HEAP POINTER TO -
						* BE POSITION INDEPENDENT
	      SUB.L	D0,A0			* ADJUST HEAP ADDRESS WITH -
						* PREVIOUSLY CALCULATED PC -
						* DIFFERENCE
	      MOVE.L	A0,A1			* SAVE A0
              ADDQ.L    #4,A0			* __HEAP POINTS TO ADDRESS -
              MOVE.L    A0,(A1)			* JUST BEYOND ITSELF
              MOVE.L    #0,A6			* FRAME POINTER INITIALIZATION
*%*
*%*	      ALLOCATE SPACE FOR LIBRARY DATA AND STACK FOR 1 TASK AND
*%*	      ADJUST POINTERS APPROPRIATELY 
*%*
*%  	      MOVE.L	__HEAP,A5	* ALLOCATE MEMORY FOR DATA AND -
*%  	      MOVE.L	A5,D0		* STACK SPACE OUT OF HEAP SPACE
*%	      ADD.L	#.SIZEOF.(zerovars)+.SIZEOF.(stack)+3,D0
*%	      LSR.L	#2,D0		* SHIFT TO LONG WORD ALIGN
*%	      LSL.L	#2,D0		* AND SHIFT BACK
*%	      MOVE.L	D0,SP		* PLACE IN STACK POINTER
*%	      MOVE.L	SP,__HEAP	* ADJUST HEAP ADDRESS
*
*	      THE FOLLOWING CODE CLEARS THE zerovars SECTION
*
	      LEA.L	.STARTOF.(zerovars),A0	* START OF SECTION
	      SUB.L   	D0,A0			* ADJUST HEAP ADDRESS WITH -
						* PREVIOUSLY CALCULATED PC -
						* DIFFERENCE
*
*%	      MOVE.L	A5,A0				* START OF THE SECTION
*%	      ADD.L	#?A5,A5				* ADD OFFSET TO A5
*%	      ADD.L	#-.STARTOF.(zerovars),A5	* SUBTRACT SECTION START
*
	      MOVE.L	#.SIZEOF.(zerovars),-(SP)	* LENGTH OF THE SECTION
	      CLR.L	-(SP)		    		* ZERO TO STACK
	      MOVE.L	A0,-(SP)			* START OF SECTION
	      JSR	ADDR(_memset)		        * CALL MEMSET TO ZERO
	      ADD.L	#12,SP				* ADJUST STACK
*%*
*%*	      THE FOLLOWING CODE CLEARS THE userzero SECTION, IF IT EXISTS
*%*
*%	      MOVE.L	#.SIZEOF.(userzero),-(SP)	* LENGTH OF THE SECTION
*%	      CLR.L	-(SP)		    		* ZERO TO STACK
*%	      MOVE.L	#.STARTOF.(userzero),-(SP)	* SECTION START
*%	      JSR	ADDR(_memset)		        * CALL MEMSET TO ZERO
*%	      ADD.L	#12,SP				* SHRINK STACK
*
*
#if ! _STR_CMP (_PID_REG, "A5")
*
*	      THE FOLLOWING STATEMENT SHOULD NOT BE USED IF A5 RELATIVE
*	      ADDRESSING IS USED FOR FULLY RE-ENTRANT LIBRARIES.
*
	      MOVE.L	#?A5,A5			* A5 LIBRARY INITIALIZATION
#endif
*
*	      CALL TO ROUTINE WHICH ENABLES CACHE
*	      THIS ROUTINE IS A STUB AND MUST BE USER DEFINED FOR EACH 
*	      APPLICATION.
*
*	      JSR	ADDR(__enable_cache)	* ENABLE CACHE
*
*	      THE ROUTINE __START INITIALIZES ALL NON-ZERO MEMORY,
*	      OPENS stdin, stdout, stderr, stdaux, AND stdprn.  IT THEN
*	      CALLS main.
*
              JSR       ADDR(__START)	* CALL C INITIALIZATION ROUTINE
*
*	      __START SHOULD NEVER RETURN.  HOWEVER, IF IT DOES, CALL exit()
*	      TO TERMINATE
*
	      MOVE.L	D0,-(SP)		* PUSH RETURN VALUE ON STACK
	      JSR	ADDR(_exit)		* CALL EXIT -- NO RETURN
*
*	      __exit IS CALLED BY exit().  
*	      IT THEN EXECUTES A STOP INSTRUCTION.
*
__exit:
	      STOP      #$2700
              BRA.S	__exit
              RTS
*
*	      DEFINE _enable_cache ROUTINE TO ENABLE CACHES.
*	      ONCE CODE HAS BEEN WRITTEN FOR A PARTICULAR APPLICATION,
*	      THE ABOVE CALL TO __enable_cache CAN BE UNCOMMENTED.
*
*__enable_cache:
*	      INSERT CODE HERE TO ENABLE CACHES
*	      RTS
*
*	DEFINE CODE LABEL THAT CONTAINS LINK TIME PROGRAM/LOCATION COUNTER 
*	FOR CALCULATING POSITION INDEPENDENT STACK TOP AND HEAP
*
	      SECTION code,,C
__PC_LABEL    DC.L	*
*
*	DEFINE THE SECTION heap AND DEFINE __HEAP SYMBOL
*
              SECTION   heap,,D			* HEAP SECTION
              XDEF      __HEAP            
__HEAP	      DS.L      1
              END       ENTRY
#pragma	endasm

#endif /* EXCLUDE_entry */
