#ifdef CONFIGURATION_FILE
  /* Library Configuration, MRI Internal Use Only */
  #define quote(a) #a
  #define apply(f,s) f(s)
  #include apply(quote, CONFIGURATION_FILE)
#endif

#if !EXCLUDE_csys
 
/*
* C System Initialization Routine
*       - Copyright 1985 to 1991, 1992 Microtec Research, Inc.
*	- This program is the property of Microtec Research, Inc,
*/

/*	@(#)csys.c	1.31 10/1/92	*/

/* This library assumes that the following UNIX style system routines exist:

int close(fno) int fno;
    Closes the file associated with the file descriptors fno (returned by
    open() or creat()).  Should return 0 if all goes well or -1 on error.

int creat(filename,prot) char *filename; int prot;
    Creates and opens (for writing) a file named filename with protection
    as specified by prot.  For output devices like terminals that cannot
    be created, it should just open the device.  Creat should return a
    file descriptor (or "file handle") for the file it opens.  On failure
    it should return -1.

void _exit(code) int code;
    Exits from the program, with a status code specified by code.
    Should not return.
    NOTE:  Code for _exit is located in "entry.c".

void exit (val) int val;
    Executes all functions specified in atexit() function calls.  Closes
    all open files and then calls _exit using "val" as the argument.  Does
    not return.

long lseek(fno, offset, whence);
    Positions a file associated with the file descriptor fno to an arbitrary
    byte position specified by offset and returns the new position as a long.
    If whence is 0, the new position is relative to the beginning of the
    file.  If whence is 1, the new position is relative to the current
    position.  If whence is 2, the new position is relative to the end
    of the file.

int read(fno,buf,nbyte) int fno, nbyte; char *buf;
    Reads at most nbyte bytes into buf from the file connected to fno (where
    fno is one of the file descriptors returned by open() or creat()). It
    should return the number of bytes read (a value of 0 is used to
    indicate EOF), or a -1 on error.  All library input occurs through
    the read function.
	
int open(filename, flags, mode) char *filename; int type, mode;
    Opens the specified file, depending on the indicated type,  the types are
    as follows:

		O_RDONLY        0x0000		open for read only
		O_WRONLY        0x0001 		open for write only
		O_RDWR          0x0002		open for read and write
		O_APPEND        0x0008		writes performed at EOF
		O_CREAT         0x0200		create file
		O_TRUNC         0x0400		truncate file
		O_FORM          0x4000		text file
		O_BINARY	0x8000		binary file

    The value of mode is always set to 0744 for UNIX compatibility.
    Open should return a file descriptor (or "file handle") for the file
    it opens.  On failure it should return -1.

char *sbrk (size) int size;
    This should increment the heap pointer by size bytes
    and return the old heap pointer.  If there is not enough space on the
    heap, it should return -1.

int write(fno,buf,nbyte) int fno, nbyte; char *buf;
    Writes at most nbyte bytes into the file connected to fno (where fno is
    one of the file descriptors returned by open() or creat()) into buf.  It
    should return the number of bytes written, or a -1 to indicate an error.
    All library output occurs through the write function.

    If read or write is called is called, the routines _INCHRW and _OUTCHR,
    respectively, must also be provided.  _INCHRW reads from an input device
    and returns an integer of value 0..255 or -1 for error.  _OUTCHR writes
    one character to an output device; its return value is ignored.

The above routines should use the variable errno to explain what went wrong
when problems occur (the various error codes are defined in errno.h).

Stubs or minimal implementations for the above routines have been provided
in files residing in the directory containing this file.  The user must
provide working versions of these routines if they are used in used in his
application.

*/

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <time.h>
#include <mriext.h>		/* define stdaux and stdprn */

/************************************************************************/
/*	Note:	The following variables, _simulated_input and		*/
/*		_simulated_output, are used by inchrw.c and outchr.c	*/
/*		to allow reading and writing of data through the	*/
/*		debugger.  They should be removed when inchrw.c and	*/
/*		outchr.c are rewritten for a particular application.	*/	
/*									*/
/*		The variables are initialized to place them in the	*/
/*		initialized data section.  The #pragma is then used to	*/
/*		place the variables in a unique section called		*/
/*		"ioports".						*/
/************************************************************************/
#pragma	options	-NIioports
volatile char _simulated_input = 0;	/* used by simulator */
volatile char _simulated_output= 0;	/* used by simulator */	

#ifdef	BUILD_ARGV

char	 _com_line [512];		/* the command line */
#define	 MAX_ARGC 32
static void build_argv (void);	/* computes argc and builds argv array */

#else	/* ! BUILD_ARGV */

#define MAX_ARGC 1

#endif	/* ! BUILD_ARGV */

#define	 _ATEXIT_MAX	32			/* Do not modify */
void	 (*_atexit_stack[_ATEXIT_MAX]) (void);	/* atexit function stack */
short	 _atexit_top;				/* index used by atexit */
void	 _atexit_functs ();

void	(*_sig_functs[6]) (int);		/* signal handler addresses */
						/* used by signal() and */
						/* raise() */

char	       **_environ;			/* the environment vector */
static unsigned  argc;				/* the argument count */
static char	*argv [MAX_ARGC];		/* the argument vector */


FILE	  _iob[FOPEN_MAX];
int	  errno;

char     *_lastp;	/* variable to be used in 'strtok' */
long      _randx;	/* variable to be used in 'rand' */
char      _ctbuf[26];	/* array used by ctime to return time date string */
struct tm _xtm;		/* return structure used by time functions */

#define HEADER struct mem

HEADER {
	HEADER    *next;
	unsigned  size;
	};

HEADER	 _membase;
HEADER	*_avail;
char	 _badlist;

/************************************************************************/
/*  This is a sample of the _START() routine which is called by the	*/
/*  user's initialization routine to start a C program.  		*/
/*									*/
/*									*/
/*  *	It defines and initializes variables for run-time functions	*/
/*	'strtok', 'malloc', 'rand', time, and i/o functions.  It also	*/
/*	defines 'errno'.						*/
/*									*/
/*  *	If the preprocessor symbol "_INITDATA" is set, the initcopy	*/
/*	routine is called to initialize RAM if the linker INITDATA	*/
/*	command is used.						*/
/*									*/
/*  *	It opens stdin, stdout, stderr, stdaux, and stdprn to the	*/
/*	console.							*/
/*	These streams are opened unbuffered.				*/
/*									*/
/*  *	Generate error messages if the initcopy routine has failed.	*/
/*									*/
/*  *	Then it calls the user's main() function.			*/
/*									*/
/*  Before entering _START(), the execution environment should already	*/
/*  be set up, including the heap, the stack, and, optionally, the	*/
/*  command line.							*/
/*									*/
/*  The routine _initcopy is used to initialize RAM when the linker	*/
/*  INITDATA command is used.  Remove the #if _INITDATA directives and	*/
/*  associated #endif's if the command INITDATA is used.		*/
/*									*/
/*  Initcopy is called in this routine to insure that stderr is opened	*/
/*  when it is called.  The user may adjust the manner in which		*/
/*  initcopy is called and how error conditions are handled to fit his	*/
/*  application.							*/
/*									*/
/*  NOTE:  The tests which generate error messages for the initcopy	*/
/*	   routine may be removed once testing is complete.		*/
/*									*/
/*  NOTE:  The opening of any stream in this file may be removed if	*/
/*	   that stream is not used in the user program.			*/
/************************************************************************/

_START (void)

{
#if _INITDATA
    int _initcopy ();
    int initReturn;

    initReturn = _initcopy ();
#endif

    _randx = 1;					/* initialize for 'rand'  */
    _avail = _membase.next = &_membase;		/* initialize for malloc */

            /* OPEN THE STANDARD I/O FILES */

    stdin->_file = 0;
    stdin->_flag = _IOREAD | _IONBF;
    stdout->_file = 1;
    stdout->_flag = _IOWRT | _IONBF;
    stderr->_file = 2;
    stderr->_flag = _IOWRT | _IONBF;
    stdaux->_file = 3;
    stdaux->_flag = _IOWRT | _IOREAD |_IONBF;
    stdprn->_file = 4;
    stdprn->_flag = _IOWRT | _IONBF;

#if _INITDATA
    if (initReturn)
      	{
	static const char init[]  = "Data initialization failed - ";
	static const char start[] = "No starting point\n";
	static const char known[] = "Unknown operation\n";
	static const char end[]   = "No end mark\n";

	write (2, (char *) init, sizeof(init)-1);	/* Write to stderr */
	if (initReturn == 1)
	    write (2, (char *) start, sizeof(start)-1);
	else if (initReturn == 2)
	    write (2, (char *) known, sizeof(known)-1);
	else
	    write (2, (char *) end, sizeof(end)-1);
	exit (1);			/* fatal error -- abort execution */
	}
#endif

#ifdef BUILD_ARGV
    build_argv ();
#else
    argv[0] = (char *) NULL;		/* As per ANSI */
#endif
    exit (main (argc, argv, _environ));
}

#ifdef BUILD_ARGV

static void build_argv (void)	/* Constructs the argv array from the */
{				/* command line (_com_line). */
    char * line = _com_line;

    for (argc = 0; argc < MAX_ARGC; ) {
	/* strip white space */
	while (*line == ' ' || (*line >= '\t' && *line <= '\r')) line++;
	if (*line == '\0') break ;

	/* point to next token */
	argv [argc++] = line ;

	/* skip over and terminate this token */
	while (    *line != '\0'
		&& *line != ' '
		&& !(*line >= '\t' && *line <= '\r')
	      ) line++ ;
	if (*line == '\0') break ;
	*line++ = '\0' ;
    }
    argv[argc] = (char *) NULL;                 /* as per ANSI */
}
#endif		/* BUILD_ARGV */
 
#else
	_kill_warning();	/* Eliminates compiler warnings */
#endif /* EXCLUDE_csys */
 
