; WINFUNC.LSP
; 
; Functions and constants for accessing Windows DLL functions.
;
; (c) 1993 Cyco Software.
;

; constants

(setq MB_OK 0)
(setq MB_YESNO 4)
(setq MB_ICONQUESTION 32)
(setq MB_ICONEXCLAMATION 48)
(setq MB_ICONINFORMATION 64)
(setq IDYES 6)
(setq IDNO 7)


; functions

(defun messagebeep (nVal)
	(dllfunc "user.exe" "MESSAGEBEEP" 1 SHORT nVal)
)

(defun GetFocus ()
	(dllfunc "user" "GETFOCUS" 0)
)

(defun wMessageBox (hwndOwner szCaption szText wType)
	(dllfunc "user" "MESSAGEBOX" 4
		SHORT hwndOwner STRING szText STRING szCaption SHORT wType)
)

(defun findwindow (szClassName szWindowName)
	(dllfunc "user.exe" "findwindow" 2
		STRING szClassName STRING szWindowName)
)

(defun flashwindow (hwnd)
	(dllfunc "user.exe" "flashwindow" 2 SHORT hwnd SHORT 1)
	(dllfunc "user.exe" "flashwindow" 2 SHORT hwnd SHORT 1)
)

(defun setfocus (hwnd)
	(dllfunc "user.exe" "setfocus" 1 SHORT hwnd)
)

(defun exitwindows ()
	(dllfunc "user.exe" "exitwindows" 2 LONG 0 SHORT 0)
)

(defun getversion (wVersion szResult)
	; locals: wVersion, szResult
	(defun trunc (dNumber)
		(if
			(strchr dNumber ".")
			;(substr dNumber 1 (- (strchr dNumber ".") 1))
			(leftstr dNumber (- (strchr dNumber ".") 1))
			dNumber
		)
	)
	(setq wVersion (dllfunc "kernel" "getversion" 0))
	(setq szResult
		(strcat
			(- wVersion (* (trunc (/ wVersion 256)) 256))
			"."
			(trunc (/ wVersion 256))
		)
	)
	(free "trunc")
	szResult
)
