; AMACAD.LSP
; 
; This file contains all functions for the connection between
; AutoManager for Windows and AutoCAD for Windows.
;
; (c) 1993 Cyco Software.
;

(setq AcadClassName "AutoCAD.gfx")
; This is the class name of the AutoCAD main window. It is used to see if
; AutoCAD is running.
;

(setq szAcadDotExe "acad.exe")
(setq szAcadDotCfg "acad.cfg")
; these are the file names of the AutoCAD executable and configuration files.
;

(setq Acad12IdentiFile "acad.dll")
(setq Acad11IdentiFile "acadwin.dll")
; in AutoCAD release 12 the server application name has changed from 
; "AUTOCAD" to "AUTOCAD.DDE". We check the existence of files to
; determine whether we're using AutoCAD Release 11 or 12.

(defun AttentionBox (szText)
	(wMessageBox (GetFocus) "Attention:" szText
		(+ MB_OK MB_ICONEXCLAMATION)
	)
)

(defun AcadConfYesNo (szText)
	(=
		(wMessageBox
			(findwindow AMWin NULL)
			"Configure AutoCAD Launch"
			szText
			(+ MB_ICONQUESTION MB_YESNO)
		)
		IDYES
	)
)

(defun AcadConfInput (szText szDefault)
	(InputBox
		"Configure AutoCAD Launch"
		szText
		szDefault
	)
)

(defun AcadConfInfo (szText)
	(wMessageBox
		(findwindow AMWin NULL)
		"Configure AutoCAD Launch"
		szText
		(+ MB_OK MB_ICONINFORMATION)
	)
)


(defun AcadAddFileToDir	(szDir szFile)
	; Add a filename to a directory specification in which the 
	; last backslash of szDir is optional
	1
)

(defun AcadCheckIsRunning ()
	(if
		(IsRunning AcadClassName)
		1
		(progn
			(AttentionBox "AutoCAD is not running. Launch AutoCAD first.")
			0
		)
	)
)

(defun AcadCheckPath ()
	(fileexist
		(strcat
			(getcfgvar
				(getsysvar "CMSFILE")
				"AutoCAD variables" "AcadDir"
			)
			"\\"
			szAcadDotExe
		)
	)
)

(defun AcadCheckNetwork ()
	(if
		(= (getcfgvar (getsysvar "CMSFILE") "AutoCAD variables" "AcadOnNet")
			1
		)
		(fileexist
			(strcat
				(getcfgvar
					(getsysvar "CMSFILE")
					"AutoCAD variables" "AcadConfDir"
				)
				"\\"
				szAcadDotCfg
			)
		)
		1
	)
)

(defun AcadConfCmdLine (szCmdLine)
	; locals: szCmdLine

	; Ask other commandline options
	(setq szCmdLine
		(getcfgvar
			(getsysvar "CMSFILE")
			"AutoCAD variables"
			"AcadCmdL"
		)
	)
	(if
		(AcadConfYesNo 
			(strcat
				"AM-Classic will launch AutoCAD using the following command line options:\n"
				(if (strlen szCmdLine)
					szCmdLine
					"\t(no options)"
				)
				"\n"
				"Do you want to change this?"
			)
		)
		(setcfgvar
			(getsysvar "CMSFILE")
			"AutoCAD variables" "AcadCmdL"
			(AcadConfInput
				"AutoCAD command line:"
				szCmdLine
			)
		)
	)
)

(defun AcadSetCmdLine (szConfDir fResult)
	; Locals: szConfDir fResult
	;

	(setq fResult 0)

	; set the network option:
	(if
		(AcadConfYesNo "Is AutoCAD installed on a network drive?")
		(progn
			(setcfgvar (getsysvar "CMSFILE") "AutoCAD variables" "AcadOnNet" 1)
			(setq szConfDir
				(AcadConfInput
					"AutoCAD configuration directory:"
					(getcfgvar
						(getsysvar "CMSFILE")
						"AutoCAD variables"
						"AcadConfDir"
					)
				)
			)
			(if
				(fileexist (strcat szConfDir "\\" szAcadDotCfg))
				(progn
					(setcfgvar
						(getsysvar "CMSFILE")
						"AutoCAD variables" "AcadConfDir"
						szConfDir
					)
					(setcfgvar
						(getsysvar "CMSFILE")
						"AutoCAD variables" "AcadCmdL"
						(strcat
							"/c"
							(getcfgvar
								(getsysvar "CMSFILE")
								"AutoCAD variables"
								"AcadConfDir"
							)
						)
					)
					(setq fResult 1)
				)
				(progn
					(AttentionBox
						(strcat
							"The directory "
							szConfDir
							" does not contain a configuration file."
						)
					)
					(setq fResult 0)
				)
			)
		)
		(progn
			(setcfgvar (getsysvar "CMSFILE") "AutoCAD variables" "AcadOnNet" 0)
			(setcfgvar
				(getsysvar "CMSFILE")
				"AutoCAD variables" "AcadCmdL" " "
			)
			(setq fResult 1)
		)
	)

	; Ask other commandline options
	(if fResult 
		(AcadConfCmdLine)
	)

	fResult
)

(defun AcadConfSetup ()
	(setcfgvar
		(getsysvar "CMSFILE")
		"AutoCAD variables" "AcadDir"
		(AcadConfInput "AutoCAD executable directory:" 
			(getcfgvar
				(getsysvar "CMSFILE")
				"AutoCAD variables"
				"AcadDir"
			)
		)
	)
	(if	
		(AcadCheckPath)
		(progn
			(AcadSetCmdLine)
			(if (AcadCheckNetwork)
				1
				0
			)
		)
		(progn
			(AttentionBox 
				(strcat
					szAcadDotExe
					" is not in "
					(getcfgvar
						(getsysvar "CMSFILE")
						"AutoCAD variables"
						"AcadDir"
					)
				)
			)
			0
		)
	)
)

(defun AcadAskSetup ()
	(if
		(AcadConfYesNo
			"Because AM-Classic has not yet been configured for launching AutoCAD, you will be asked some questions first. After you have entered the right settings, AutoCAD will be started.\nNote: AutoCAD should be installed properly prior to answering these questions.\n\nDo you want to continue?"
		)
		(progn
			(AcadConfSetup)
			(and (AcadCheckPath) (AcadCheckNetwork))
		)
		0
	)
)

(defun AcadCheckSetup ()
	(if (and (AcadCheckPath) (AcadCheckNetwork))
		1
		(AcadAskSetup)
	)
)

(defun AcadExistInAcadDir (szFileName szAcadDir)
	; Locals: szAcadDir
	(setq szAcadDir
		(getcfgvar
			(getsysvar "CMSFILE")
			"AutoCAD variables" "AcadDir"
		)
	)
	; see if a file exists in the AutoCAD executable directory
	(if 
		(fileexist
			(strcat
				szAcadDir
				"\\"
				szFileName
			)
		)
		1
		0
	)
)

(defun AcadGetVersion (nVersion)
	; determine the release number based on the existence of a 
	; certain file in the AutoCAD executable directory
	;
	; Locals: nVersion

	(setq nVersion 0)
	(if 
		(AcadExistInAcadDir Acad11IdentiFile)
		(setq nVersion 11)
	)
	(if 
		(AcadExistInAcadDir Acad12IdentiFile)
		(setq nVersion 12)
	)
	(while (and (/= nVersion 11) (/= nVersion 12))
		(setq nVersion
			(InputBox
				"AutoCAD Release Number?"
				"Enter the AutoCAD Release Number (11 or 12):"
				12
			)
		)
	)
	nVersion
)

(defun AcadSetDdeName (nVersion)
	; Locals: nVersion
	(if
		(AcadCheckPath)
		(progn
			(setq nVersion (AcadGetVersion))
			(if (= nVersion "11")
				(setq AcadDdeName "AUTOCAD")
				(setq AcadDdeName "AUTOCAD.DDE")
			)
		)
		(print "Invalid AutoCAD path.")
	)
)

(defun AcadLaunchSetup ()
	(if (AcadConfYesNo
		"Because AM-Classic needs to know where the AutoCAD executable is stored and what extra command line options it should use to run AutoCAD, you will now be asked some questions.\n\nDo you want to continue?")
		(if (AcadConfSetup)
			(AcadConfInfo "AM-Classic is now configured for launching AutoCAD.")
			(AcadConfInfo "AM-Classic has NOT been configured properly for launching AutoCAD.")
		)
			
	)
)

(defun AcadLaunch ()
	(if
		(AcadCheckSetup)
		(run
			(strcat
				(getcfgvar (getsysvar "CMSFILE") "AutoCAD variables" "AcadDir")
				"\\"
				szAcadDotExe
				" "
				(getcfgvar (getsysvar "CMSFILE") "AutoCAD variables" "AcadCmdL")
			)
		)
	)
)

(defun AcadLaunchFile ()
	(if
		(AcadCheckSetup)
		(run
			(strcat
				(getcfgvar (getsysvar "CMSFILE") "AutoCAD variables" "AcadDir")
				"\\"
				szAcadDotExe
				" "
				(getcfgvar (getsysvar "CMSFILE") "AutoCAD variables" "AcadCmdL")
				" "
				(getsysvar "CURRENTDRAWING")
			)
		)
	)
)

(defun AcadInsertBlock ()
	(if (AcadCheckIsRunning)
		(if (AcadCheckSetup)
			(progn
				(AcadSetDdeName)
				(DdeDoExecute
					AcadDdeName
					(strcat
						"[insert "
						(dos2acadpath (getsysvar "CURRENTDRAWING"))
						" ]"
					)
				)
				(setfocus (findwindow AcadClassName NULL))
			)
		)
	)
)

(defun AcadInsertXref ()
	(if (AcadCheckIsRunning)
		(if (AcadCheckSetup)
			(progn
				(AcadSetDdeName)
				(DdeDoExecute
					AcadDdeName
					(strcat
						"[xref a "
						(dos2acadpath (getsysvar "CURRENTDRAWING"))
						" ]"
					)
				)
				(setfocus (findwindow AcadClassName NULL))
			)
		)
	)
)
