#
# This make file was built to use Watcom C/386 Compiler,
# WMAKE make utility, and WLINK linker.
#
########################################################
#
#       assumes set WATCOM=<path to compiler directory>
#               set WEITEK=1 to choose Weitek compilation options
#

!ifdef %WEITEK

# Weitek coprocessor specific compiler options

CFLAGS=/i=$(%WATCOM)\h /i=$(INC) /s /j /ez /mf /fpi /3s /oail /zq
CCLIB=$(%WATCOM)\LIB386\DOS\CLIB3S.LIB $(%WATCOM)\LIB386\MATH387S.LIB $(%WATCOM)\LIB386\DOS\EMU387.LIB
PROCDIR=..\wtk
# SUFX should be _i for an intel coprocessor or _w for a weitek coproccesor
SUFX=_w

!else

# Intel coprocessor specific compiler option

CFLAGS=/i=$(%WATCOM)\h /i=$(INC) /s /j /ez /mf /fpi87 /3s /oail /zq
CCLIB=$(%WATCOM)\LIB386\DOS\CLIB3S.LIB $(%WATCOM)\LIB386\MATH387S.LIB
PROCDIR=..\386
# SUFX should be _i for an intel coprocessor or _w for a weitek coproccesor
SUFX=_i
!endif

CC=$(%WATCOM)\bin\wcc386p $(CFLAGS)
INC=..\..\..\INC
CPF=

# IPAS should be set to ixp, pxp, axp, or sxp depending on the type of
# process being compiled.
IPAS=SXP

!ifdef %XPDEBUG
LIBNAME=..\..\..\LIB\xpwcd.lib $(CCLIB)
!else
LIBNAME=..\..\..\LIB\xpwc.lib $(CCLIB)
!endif

.c.obj:
       $(CC) $*.c $(CPF)
# assembler information
IL=.\\
AS=386asmp $(AFLAGS)
APF=-NOLIST -TWOCASE -i $(IL)
.asm.obj:
         $(AS) $* $(APF)

# Example program being compiled and linked
PROGNAME=VARY

all : $(PROGNAME)$(SUFX).$(IPAS) .SYMBOLIC

clean: .SYMBOLIC
   if exist $(PROGNAME).obj del $(PROGNAME).obj

$(PROGNAME)$(SUFX).$(IPAS): $(PROGNAME).exp
   if exist $(PROGNAME)$(SUFX).$(IPAS) del $(PROGNAME)$(SUFX).$(IPAS)
   ren $(PROGNAME).exp $(PROGNAME)$(SUFX).$(IPAS)

$(PROGNAME).exp : $(PROGNAME).obj $(LIBNAME)

   %create link.opt
   %append link.opt OPTION MAP
   %append link.opt FILE $(PROCDIR)\$(IPAS).obj
   %append link.opt FILE $(PROGNAME).obj
   %append link.opt LIBPATH $(%WATCOM)\LIB386;$(%WATCOM)\LIB386\DOS
   for %i in ($(LIBNAME)) do %append link.opt LIBRARY %i
   %append link.opt FORMAT PHARLAP
   %append link.opt OPTION DOSSEG
   %append link.opt NAME $^@

   wlink @link.opt
   del link.opt

$(PROGNAME).obj : $(PROGNAME).c $(INC)\$(IPAS).h
