/******************************************************************************
      (C) Copyright 1992 by Autodesk, Inc.

      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and 
      intended  to  work  solely  with  Autodesk, Inc. products, and 
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright  
      1992 by Autodesk, Inc."

      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
      UNINTERRUPTED OR ERROR FREE.

*******************************************************************************/

/*  3D Texture Function Interface    */

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include "sxp.h"

static char *state;
static DlgEntry *cdialog;
static int state_size;

#define CFGTITLE 0
#define CFGONOFF 1
#define CFGYESNO 2
#define CFGRADIO 3
#define CFGLFLOAT 4
#define CFGFLOAT 5
#define CFGLINT 6
#define CFGINT 7
#define CFGFILENAME 8
#define CFGSTRING 9
#define CFGSLIDER 10
#define CFGVAR 11
#define CFGCOLOR 11

static int FindDlgType(char *s) {
	if (s[0]=='-') s++;
	if (strncmp(s,"TITLE",5)==0) return(CFGTITLE);
	if (strncmp(s,"ON-OFF",5)==0) return(CFGONOFF);
	if (strncmp(s,"YES-NO",5)==0) return(CFGYESNO);
	if (strncmp(s,"RADIO",5)==0) return(CFGRADIO);
	if (strncmp(s,"LFLOAT",6)==0) return(CFGLFLOAT);
	if (strncmp(s,"FLOAT",5)==0) return(CFGFLOAT);
	if (strncmp(s,"LINT",4)==0) return(CFGLINT);
	if (strncmp(s,"INT",3)==0) return(CFGINT);
	if (strncmp(s,"SLIDER",6)==0) return(CFGSLIDER);
	if (strncmp(s,"COLOR",5)==0) return(CFGCOLOR);
	if (strncmp(s,"FILENAME",8)==0) return(CFGFILENAME);
	if (strncmp(s,"STRING",6)==0) return(CFGSTRING);
	return(0);
	}

static int DlgHasVar(char *s) {
	if (s[0]=='-') s++;
	if (strncmp(s,"TITLE",5)==0) return(0);
	else return(1);
	}

/* Work buffer */

char gp_buffer[256]="";

/* Configuration dialog contents */

typedef struct{
	ulong magic;	/* Magic number */
	int opcode;		/* What .EXP wants to do in 3D Studio */
	int usercode;	/* What .EXP wants to do when it gets back */
	int status;		/* How it all came out */
	} BufHdr;


typedef struct{
	unsigned long size;
	ulong data;
	} SXPcfg;

typedef struct{
	ulong magic;	/* Magic number */
	int opcode;		/* What .EXP wants to do in 3D Studio */
	int usercode;	/* What .EXP wants to do when it gets back */
	int status;		/* How it all came out */
	union {
		char string[64];
		Sxpdata sxp;
		SXPcfg cfig;
		} data;
	} SXPbuf;

static int bufsize=sizeof(EXPbuf);


/* Pointers to bitmaps living in 3D Studio's memory	*/
/* These are "_far" pointers -- 48 bits worth		*/
static EXPbuf _far *fexpbuf;	/* Comm buffer struct ptr */

/*-------------------------------------------------*/

/* Local Data */
static EXPbuf localbuf;

#define sxd localbuf.data.sxp

static int dialog_ix, nvar, num_dialog_items;
static int version=200;

long xpmagic,xpmainseg,xpbuffer;

static void InitSxp() {
	int bufs2;
	state = ClientGetState(&state_size);
	bufsize = sizeof(SXPbuf);
	bufs2 = state_size+sizeof(BufHdr)+4;
	if (bufs2>bufsize) bufsize = bufs2;
	}

void main(void)  {
	int type;
	ulong *pl;
	int i,k;
	OVL val;

	/* Check magic number */
	if(xpmagic!=SXP_MAGIC)	{
	bad_magic:
		localbuf.status=0;
		return;
		}

    if(localbuf.ver.magic==VER_MAGIC)
        version=localbuf.ver.version;

	/* Copy comm buffer data to our structure */
	FP_SET(fexpbuf,xpbuffer,xpmainseg);
	far_to_near(&localbuf,fexpbuf,bufsize);

	/* Double-check its magic number */
	
	if(localbuf.magic!=SXP_MAGIC)
		goto bad_magic;

	switch(localbuf.usercode) {
		case EXP_STARTUP:		/* Initial startup */
			InitSxp();
			ClientStartup();
			break;

		case SXP_3D_TEXT:
			Client3DText(&sxd); /* what we're here for */
			localbuf.status=1;
			break;

		case SXP_3D_OPAC:
			Client3DOpac(&sxd); /* what we're here for */
			localbuf.status=1;
			break;

		case SXP_3D_BUMP:
			Client3DBump(&sxd); /* what we're here for */
			localbuf.status=1;
			break;

		case EXP_GET_CONFIG:
			state = ClientGetState(&state_size);
  	#define pd localbuf.data.cfig
			if(pd.size!=state_size) {
				ClientResetState();
				}
			else 	{
 				long *p, *q;
				p = (long *)&pd.data;
				q = (long *)state;
				if (p[0]!=q[0]) 
					ClientResetState();
				else 				
					memcpy(state,&pd.data,state_size);
				}
	#undef pd
			cdialog = ClientDialog(0);
			if(cdialog->s==NULL) {
				goto var_done;
				}
			localbuf.opcode=EXP_INIT_DIALOG;
			localbuf.usercode=0x0100;
			localbuf.status=1;
			break;
	
		case 0x0100:
			dialog_ix=0;
	
		case 0x0110:
			cdialog = ClientDialog(dialog_ix);
			if(cdialog->s==NULL)
				goto dia_done;
			strcpy(localbuf.data.string,cdialog->s);
			localbuf.opcode=EXP_ADD_DIALOG;
			localbuf.usercode=0x0110;
			localbuf.status=1;
			dialog_ix++;
			break;
	
			dia_done:
			num_dialog_items = dialog_ix;

			dialog_ix=0;
			nvar = 0;
	
		case 0x0120:
			for ( ; dialog_ix<num_dialog_items ; dialog_ix++) {
				cdialog = ClientDialog(dialog_ix);
				if (DlgHasVar(cdialog->s)) break;
				}
			if (dialog_ix>=num_dialog_items) 
				goto var_done;
			val.ul = ClientGetStateVar(cdialog->id);
			type = FindDlgType(cdialog->s);
			switch(type) {
				case CFGLINT: case CFGINT:
					sprintf(localbuf.data.string,"VARIABLE=\"%d\"",val.i);
					nvar++;
					break;
				case CFGONOFF: case CFGYESNO:
				case CFGRADIO: case CFGSLIDER:
					sprintf(localbuf.data.string,"VARIABLE=%d",val.i);
					nvar++;
					break;
				case CFGCOLOR:
					sprintf(localbuf.data.string,"VARIABLE=%d,%d,%d",val.c.r,val.c.g,val.c.b);
					nvar++;
					break;
				case CFGFLOAT: case CFGLFLOAT:
					sprintf(localbuf.data.string,"VARIABLE=\"%f\"",val.f);
					nvar++;
					break;
				case CFGSTRING: case CFGFILENAME:
					sprintf(localbuf.data.string,"VARIABLE=\"%s\"",val.s);
					nvar++;
					break;
				}
			localbuf.opcode=EXP_ADD_VAR;
			localbuf.usercode=0x0120;
			localbuf.status=1;
			dialog_ix++;
			break;
	
			var_done:
			localbuf.opcode=EXP_DO_DIALOG;
			localbuf.usercode=0x0130;
			localbuf.status=1;
			break;
		case 0x0130:
			if(localbuf.status==0)	/* Cancelled */
				{
				localbuf.opcode=localbuf.usercode=EXP_TERMINATE;
				localbuf.status=0;
				break;
				}
			pl = (ulong *)&localbuf.data;
			k = 0;
			for (i=0; ; i++) {
				cdialog = ClientDialog(i);
				if (cdialog->s==NULL) break;
				if (DlgHasVar(cdialog->s))
					{
					ClientSetStateVar(cdialog->id,&pl[k]);
					k+=ClientVarSize(cdialog->id);
					}
				}

			/* done with the dialog session -- send the state back. */
			localbuf.data.cfig.size = state_size;
			memcpy(&localbuf.data.cfig.data,state,state_size);
			localbuf.opcode=EXP_PROC_DATA;
			localbuf.usercode=EXP_TERMINATE;
			localbuf.status=1;
			break;

		case EXP_PUT_CONFIG:
	#define pd localbuf.data.cfig
			if(pd.size)	{
				long *p, *q;
				if(pd.size!=state_size) {
					goto re_state;
					}
				p = (long *)&pd.data;
				q = (long *)state;
				if (p[0]!=q[0]) {
					goto re_state;
					}
				memcpy(state,&pd.data,state_size);			
				}
			else {
				re_state:
				ClientResetState();
				}
	#undef pd
			localbuf.opcode = EXP_CONFIGURED;
			localbuf.status = 1;
			break;

		case EXP_TERMINATE:
			ClientTerminate();
			localbuf.opcode=EXP_TERMINATE;	/* Terminate! */
			localbuf.status=1;	/* OK status */
			break;

		default:
			ClientTerminate();
			localbuf.opcode=EXP_TERMINATE;	/* Terminate! */
			localbuf.status=0;	/* ERROR status */
			break;
		}
	
	near_to_far(fexpbuf,&localbuf,bufsize);
	return;
	}

int studio_version()
{
return(version);
}

