/******************************************************************************
      (C) Copyright 1992 by Autodesk, Inc.

      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and 
      intended  to  work  solely  with  Autodesk, Inc. products, and 
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright  
      1992 by Autodesk, Inc."

      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
      UNINTERRUPTED OR ERROR FREE.

*******************************************************************************/


/* Defines for using .EXP programs as 3D Studio operations */

#ifndef EXPRTNS
#define EXPRTNS

#ifdef __HIGHC__
#pragma Align_members(1);  /* force byte alignment for HC3_01 */
#endif

/* define some base data types */

typedef unsigned char uchar;
typedef unsigned int uint;
typedef unsigned short ushort;
typedef unsigned long ulong;

/* Image-processing (.IXP) data */

typedef struct
{
int width;
int height;
int aspect;
void *imagein;
void *imageout;
void *alphin;
void *alphout;
int curfield;
int totfields;
} Ixpdata;

typedef struct { unsigned r,g,b; } Col24;

typedef struct	{
	float p[3];
	int curfield;
	int totfields;
	Col24 col;	    /* color for texture mapping, opacity */
	float shininess;  /* shininess of material, texture mapping only */
	float norm_pert[3];	/* normal perturbation for bump mapping */
    ulong datasize;
	void *data;
	} Sxpdata;

/* Progress data I/O structure */

typedef struct
{
char title[41];
int max;
int current;
} ProgIO;

/* Vertex data I/O structure */

typedef struct
{
int vertex;
float x,y,z;	/* XYZ coordinates */
float u,v;	/* Texture coords, if used */
} VertIO;

typedef struct
{
float x,y,z;	/* XYZ coordinates */
float u,v;	/* Texture coords, if used */
} VData;

typedef struct
{
int start,count;
VData _far *data;
} VListIO;

typedef struct
{
int face;
uint a,b,c; /* Vertex numbers for triangular face */
ulong flags;    /* See below for meanings */
ulong sm_group; /* Smoothing group bits (32) */
uint material;  /* 0-255 */
} FaceIO;

typedef struct
{
ushort a,b,c;   /* Vertex numbers for triangular face */
ulong sm_group; /* Smoothing group bits (32) */
uchar flags;    /* See below for meanings */
uchar material; /* 0-255 */
} FData;

typedef struct
{
int start,count;
FData _far *data;
} FListIO;

/* Face flags bit assignments */
#define FC_ABLINE 1
#define FC_BCLINE 2
#define FC_CALINE 4

typedef struct
{
char name[11];
uchar flags;
int verts;
int faces;
int tverts;
int curfield;	/* For Procedurals */
int totfields;	/* For Procedurals */
} ObjectIO;

/* ObjectIO flags bit assignments */

#define EXP_OBJ_HIDDEN 0x01	/* Used by PXPs only */

typedef struct
{
char name[11];
char filler;
float minx;
float maxx;
float centerx;
float miny;
float maxy;
float centery;
float minz;
float maxz;
float centerz;
} ExtInfo;

typedef struct
{
char mtlname[17];
uchar mtlnum;
} MtlIO;

typedef struct
{
int defbut;
char string[256];
} Alert;

typedef struct
{
char title[40];
char tag[30];
int min,max,step,value;
} Slider1;

typedef struct
{
char title[40];
char tag1[30],tag2[30];
int min1,max1,step1,value1;
int min2,max2,step2,value2;
} Slider2;

typedef struct
{
ulong size;         /* Number of bytes in config data */
uchar data[2048];       /* Up to 2K of data */
} Cfigdata;

typedef struct
{
float x,y,z,hangle,vangle,tilt,width;
} Ortho;

typedef struct
{
float x,y,z,tx,ty,tz,bank,focal;
} Cam;

typedef struct
{
int viewtype;
Cam camera;
Ortho ortho;
int fnum;
int dev_width,dev_height;
float dev_aspect;
float ov_zoom;
int animlength,start,end;
char homedir[66],scene[13];
} FrameInfo;

typedef struct
{
int using_fields;
int field_order;	
Cam cam1,cam2;
} FieldInfo;

typedef struct
{
long magic;	/* If 3DS >2.0, this will contain VER_MAGIC */
int version;	/* Two-decimal version #, example: 231 = V2.31 */
} VersInfo;

/* Values in 'viewtype' field: */

#define VIEW_TOP 0x3010
#define VIEW_BOTTOM 0x3020
#define VIEW_LEFT 0x3030
#define VIEW_RIGHT 0x3040
#define VIEW_FRONT 0x3050
#define VIEW_BACK 0x3060
#define VIEW_USER 0x3070
#define VIEW_CAMERA 0x3080

typedef struct {
    ulong magic;    /* Magic number */
	int opcode;	/* What .EXP wants to do in 3D Studio */
	int usercode;	/* What .EXP wants to do when it gets back */
	int status;	/* How it all came out */
	}  EXPbufHdr;

typedef struct
{
ulong magic;    /* Magic number */
int opcode;	/* What .EXP wants to do in 3D Studio */
int usercode;	/* What .EXP wants to do when it gets back */
int status;	/* How it all came out */
union		/* Parameters for the opcodes & returned values */
 {
 char string[256];
 VertIO vert;
 VListIO vlist;        /* Vertex list info added for 3DS >2.0 */
 FaceIO face;
 FListIO flist;        /* Face list info added for 3DS >2.0  */
 ObjectIO object;
 MtlIO mtl;
 ProgIO progress;
 Alert alert;
 Slider1 s1;
 Slider2 s2;
 Cfigdata cfig;
 Ixpdata ixp;
 Sxpdata sxp;
 FrameInfo finfo;
 ExtInfo exts;
 FieldInfo fldinfo;    /* Field Information added for 3DS >2.0 */
 } data;
VersInfo ver;	/* Version info added for 3DS >2.0 */
} EXPbuf;

/* Magic numbers for 3D Studio communication */

#define IXP_MAGIC	0x18273645 
#define PXP_MAGIC	0x10293847
#define AXP_MAGIC	0x29384756
#define SXP_MAGIC	0x57483920
#define VER_MAGIC	0x3D25FE1D

/* Op codes for 3D Studio communication */

#define EXP_TERMINATE	0x0000
/*
Codes 0x0001-0x01FF Reserved for internal interface codes
*/
/*
Codes 0x0200-0x0FFF Reserved for user codes
*/
#define EXP_GET_VERTEX	0x1000
#define EXP_PUT_VERTEX	0x1001
#define EXP_GET_VLIST	0x1002
#define EXP_PUT_VLIST	0x1003
#define EXP_GET_FACE	0x1010
#define EXP_PUT_FACE	0x1011
#define EXP_GET_FLIST	0x1012
#define EXP_PUT_FLIST	0x1013
#define EXP_MATERIAL	0x1015
#define EXP_PICK_OBJECT	0x1020
#define EXP_READY_OBJ	0x1021
#define EXP_CREATE_OBJ	0x1022
#define EXP_OBJ_EXIST	0x1023
#define EXP_OBJ_EXTENTS	0x1024
#define EXP_HOLD_MATRIX	0x1025
#define EXP_SLIDER1	0x1030
#define EXP_SLIDER2	0x1031
#define EXP_ALERT	0x1040
#define EXP_CONTINUE	0x1050
#define EXP_YES_NO	0x1060
#define EXP_PROMPT	0x1070
#define EXP_PROGRESS	0x1080

#define EXP_INIT_DIALOG	0x1100
#define EXP_ADD_DIALOG	0x1110
#define EXP_ADD_VAR	0x1120
#define EXP_DO_DIALOG	0x1130

#define EXP_FRAME_INF	0x1200
#define EXP_FIELD_INF	0x1210

#define EXP_V16_GRAB	0x1220	/* For testing */

/* IXP - Image processing process */
#define IXP_PROC_IMAGE	0x1300

/* SXP - Solid texture process */
#define SXP_3D_TEXT	0x1400
#define SXP_3D_OPAC	0x1401
#define SXP_3D_BUMP	0x1402

#define EXP_GET_CONFIG	0xA000 	/* 3DS->EXP, to put up config dialog */
#define EXP_PROC_DATA	0xA020	/* EXP->3DS, to return config data */

#define EXP_PUT_CONFIG	0xA100	/* 3DS->EXP, to send config data to exp */
#define EXP_CONFIGURED	0xA110	/* EXP->3DS, comes back after successful PUT_CONFIG */

#define EXP_NOP		0xFFFE	/* No operation */
#define EXP_STARTUP	0xFFFF    

/* Types of executable processes supported */

#define EXP_IXP 0	/* Image */
#define EXP_PXP 1	/* Procedural Object */
#define EXP_AXP 2	/* Animated Procedural Object */
#define EXP_SXP 3	/* Solid Texture */
#define EXP_EXP 4	/* Plain ol' Vanilla EXP */
#define EXP_EXE 5	/* Regular executable */
#define EXP_BAT 6	/* Batch file */

/* Code to handle .EXP processes */

extern ulong exp_load(char *name,int type);
extern int exp_call(ulong handle);
extern int exp_unload(ulong handle);
extern int config_an_exp(char *name,int type,void *indata,void **outdata);
extern int feed_exp_data(ulong handle,void *indata);

/*

The following macros are used to get and set the selector and offset fields
of far pointers.  The FP_SEL macro returns the 16-bit selector number field
of a far pointer.  The FP_OFF macro returns the 32-bit offset
field of a far pointer.  The FP_SET macro is used to construct a far
pointer from a selector number and offset.  It takes three arguments:
the name of the far pointer to be set, an offset, and a selector number.

*/

#define FP_SEL(fp) ((ushort)(*(((ushort *)&(fp))+sizeof(uint)/sizeof(ushort))))

#define FP_OFF(fp) ((uint)(*(uchar **)&(fp)))

#define FP_SET(fp, off, sel) ((*(uint *)&fp=(uint)(off)),\
(*(((ushort *)&fp) + sizeof(uint)/sizeof(ushort))=sel))

#endif /* EXPRTNS */
