/******************************************************************************
      (C) Copyright 1992 by Autodesk, Inc.

      This program is copyrighted by Autodesk, Inc. and is  licensed
      to you under the following conditions.  You may not distribute
      or  publish the source code of this program in any form.   You
      may  incorporate this code in object form in derivative  works
      provided  such  derivative  works  are  (i.) are  designed and 
      intended  to  work  solely  with  Autodesk, Inc. products, and 
      (ii.)  contain  Autodesk's  copyright  notice  "(C)  Copyright  
      1992 by Autodesk, Inc."

      AUTODESK  PROVIDES THIS PROGRAM "AS IS" AND WITH  ALL  FAULTS.
      AUTODESK  SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF  MER-
      CHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK,  INC.
      DOES  NOT  WARRANT THAT THE OPERATION OF THE PROGRAM  WILL  BE
      UNINTERRUPTED OR ERROR FREE.

*******************************************************************************/


/* BOX.PXP by Tom Hudson */

/* For the Metaware High C and High C/C++ compilers, turn off an
   unwanted warning message */
#ifdef __HIGHC__
pragma Offwarn(67); /* kills "switch statement has no cases" warning */
#endif

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include "pxp.h"

/* Variable definitions */

#define COLOR 1
/* The above definition is the LineID number for the dialog line
   in which the 'color' variable will be set. The integers assigned to
   the dialog lines containing variables are arbitrary. */

/************************/

/* Dialog description */

DlgEntry cdialog[]={
        0,"TITLE=\"Autodesk 3D Studio Object Builder Process\"",        /* Text strings to be
									displayed in dialog box */
	0,"TITLE=\"by Tom Hudson, Version 1.0\"",
	COLOR,"RADIO=\"AXP Color:\",\"Default\",\"From Object\"",	/* Setup for 'radio-button'
									and associated variable */
	0,NULL								/* blank line for spacing*/
	};

/* Version test value */
/* Every external process must have a unique version number  */

#define VERSION 0x71FB
	
/* State Structure definition */
/* Any variables whose values are set via dialog interface must be declared within the 'State' struct. */
typedef struct {
	ulong version;
	int obj_color;
	} State;

/* the "state" struct MUST start with a "ulong" which is the version#,
	to prevent using data from old versions of this program.
	This verification is performed automatically. */

static State init_state = { VERSION,1 };   	/* initial state settings */
static State state = { VERSION,1 };	/* default settings */

static int ix,thismtl;
static float minx,miny,minz,maxx,maxy,maxz;

/* Arrays for creation of a cube */

float *xvals[8]={&minx,&maxx,&maxx,&minx,&minx,&maxx,&maxx,&minx};
float *yvals[8]={&miny,&miny,&maxy,&maxy,&miny,&miny,&maxy,&maxy};
float *zvals[8]={&minz,&minz,&minz,&minz,&maxz,&maxz,&maxz,&maxz};
int av[12]={0,0,1,1,2,2,3,3,0,0,4,4};
int bv[12]={1,5,2,6,3,7,0,4,3,2,5,6}; 
int cv[12]={5,4,6,5,7,6,4,7,2,1,6,7};

/*----------------------------------------------------------------*/
/* Following function sets the appropriate 'State' variables based
   on the input from the dialog */
void ClientSetStateVar(int id, void *ptr) {
    OVL o;       /* Union of possible values that the dialog can return */
	ulong *ul;
	char *s;

	ul=(ulong *)ptr;
	s=(char *)ptr;
	o.ul = *ul;
	switch(id) {
        case COLOR: state.obj_color=o.i; break;  /* State variables set here
                                                    based on Union variable */
		}
	}

/* Following function sets the appropriate value of the Union 'OVL' variable
   to return values stored in the 'State' variable */
ulong ClientGetStateVar(int id) {
	OVL o;				/* Union of the values which can be requested by
                           3D Studio from the 'State' structure */
	switch(id) {
		case COLOR: o.i=state.obj_color; break;	/* Union variable set to appropriate value
                                                   from 'state' variable */
							
		}
    return(o.ul);        /* The variable requested by 3D Studio is
							returned to 3D Studio via the 'ulong' field
							of the 'Union' structure 'OVL'. */
	}

/* Following function allows 3D Studio to determine the size of
   any variable in the dialog */
int ClientVarSize(int id)
	{
	switch(id)
		{
		default:
			return(1);
		}
	}

/* Following function allows 3D Studio to determine the size of the 'State'
   structure and returns a pointer to the 'State' struct */

char  *ClientGetState(int *size) {
	*size = sizeof(State);
	return((char *)&state);
	}

/* Following function allows 3D Studio to reset the state of the
   external process */

void ClientResetState() {       
	state = init_state;     		
	}

/* Following function performs any calculations or packet-commands
   necessary before the EXP can begin */

void ClientStartup(EXPbuf *buf) {
    buf->opcode=EXP_PICK_OBJECT;  /* Packet command sent to 3D Studio initiating
                                     a 'Pick-Object' operation. */
    buf->usercode=0x0200;         /* IPAS routine to return to this label in the
                                     case checking */
	buf->status=1;
    strcpy(buf->data.string,"Pick a mesh object to box"); /* User is prompted for the
                                                             'Pick-Object' operation. The
                                                             buf->data.string's contents will
                                                             be printed in the lower left corner
                                                             of the screen. */
	}

/* Following function contains user codes which process data */

void ClientUserCode(EXPbuf *buf)
	{
	switch(buf->usercode)
		{
		case 0x0200:
			/* Set up for a cube */

            buf->opcode=EXP_READY_OBJ;      /* 3D Studio packet command for                                     opening a new object for output */
            buf->usercode=0x0210;           /* Next entry point for the
                                               ClientUserCode function */
#define ob buf->data.object
			ob.verts=8;				/* Output object has 8 vertices */
            ob.faces=12;            /* Output object has 12 triangular                                  faces */
            ob.tverts=0;            /* Output object has no textured
                                       vertices */
#undef ob
			break;
  
		case 0x0210:
			if(buf->status==0)
                goto terminate;          /* If previous operation failed, then
                                            terminate IPAS routine. */
            buf->opcode=EXP_OBJ_EXTENTS; /* 3D Studio packet command for
                                            requesting the extents of the input
                                            object */
            buf->usercode=0x0211;        /* Next entry point for the
                                            ClientUserCode function */
			buf->status=1;
			break;

		case 0x0211:
			if(buf->status==0)
                goto terminate;   /* If previous operation failed, then
                                     terminate IPAS routine. */
#define oe buf->data.exts
            minx=oe.minx;         /* Minimum x,y,z coords of input
                                     object are recorded. */
			miny=oe.miny;
			minz=oe.minz;
            maxx=oe.maxx;         /* Maximum x,y,z coords of input
                                     object are recorded. */
			maxy=oe.maxy;
			maxz=oe.maxz;
#undef oe

			ix=0;

            add_vert_loop:        /* Loop for vertex operations */
#define cv buf->data.vert
            cv.vertex=ix;         /* Set vertex number (1-8) */
            cv.x= *(xvals[ix]);   /* Set 'x' value of vertex */
            cv.y= *(yvals[ix]);   /* Set 'y' value of vertex */
            cv.z= *(zvals[ix++]); /* Set 'z' value of vertex */
#undef cv  
			buf->opcode=EXP_PUT_VERTEX;	/* 3D Studio packet command for 
                                           writing vertex information to
                                           output object */
            buf->usercode=0x0212;       /* Next entry point for the
                                           ClientUserCode function */
			buf->status=1;
			break;
		case 0x0212:
			if(ix<8)
				goto add_vert_loop;
			if(state.obj_color)
				{
                buf->opcode=EXP_GET_FACE; /* 3D Studio packet command for
                                             sequentially getting 'face' data */
                buf->usercode=0x0215;     /* Next entry point for the
                                             ClientUserCode function */
				buf->data.face.face=0;
				buf->status=1;
				break;
				}
			else
				{
                thismtl=255;              /* Set Material number */
				goto add_faces;
				}

		case 0x0215:
            thismtl=buf->data.face.material;  /* Set Material number */

			add_faces:
			ix=0;

			add_face_loop:  
#define cf buf->data.face
            cf.face=ix;                 /* Set face number for output */
			cf.a=av[ix];				/* Record face data describing
                                           which vertices are connected to
                                           each other to form faces */
			cf.b=bv[ix];
			cf.c=cv[ix];
			if(ix & 1)
				cf.flags=FC_BCLINE | FC_CALINE;	/* Edge flags to make BC 
                                                   and CA edges visible */
			else
				cf.flags=FC_ABLINE | FC_BCLINE;	/* Edge flags to make AB
                                                   and BC edges visible */
			++ix;
			cf.material=thismtl;
			cf.sm_group=0;
#undef cf
            buf->opcode=EXP_PUT_FACE;  /* 3D Studio packet command to
                                          put 'face' data to output object */
            buf->usercode=0x0220;      /* Next entry point for the
                                          ClientUserCode function */
			buf->status=1;
			break;
		case 0x0220:
			if(ix<12)
				goto add_face_loop;
#define ob buf->data.object
            strcpy(ob.name,"");        /* Set name of output object */
			ob.flags=0;
#undef ob
            buf->opcode=EXP_CREATE_OBJ; /* 3D Studio packet command to signal
                                           completion of output object. The
                                           object can now be displayed on
                                           screen and treated as any other
                                           object created in 3D Studio */

            buf->usercode=EXP_TERMINATE; /* Command used to terminate
                                            IPAS routine */
			buf->status=1;
			break;
		default:
			terminate:
			buf->opcode=buf->usercode=EXP_TERMINATE; /* all commands necessary 
                                                        to signal termination of
                                                        IPAS routine */
            buf->status=0;                           /* Set status to 'exit' */
			break;
		}
	}

void ClientTerminate(void) { 
	/* free any data structures, etc. */
	}

/* The following function allows 3D Studio to get the address of the string
   containing the dialogue. The IPAS programmer will not have to call this
   function or modify the following code, but will have to include it */

DlgEntry *ClientDialog(int n) { 
	return(&cdialog[n]); 
	}
