*	(C)Copyright LodeStone Consortium 1993 - All Rights Reserved
*	Compile with -l -n -v

	//	Check value to try to insure it's a valid filter string
#define SAVEFILTVAL			1339732

	//	Offset of various "fields" in the save filter string
#define SAVEFILTOFS			 1
#define RECNOOFS			 5
#define RLOFS				 9
#define FILTEROFS			13


*	cmSaveFilter()
*
*	action:	Save the current filter state.
*
*	input:	None.
*
*	return:	Character string which has the filter state information in it.
*
*	alters:	o	Creates a duplicate of the Filter RecordList

function cmSaveFilter()
local rlFilter := rlGetFilter()

*	If we've got a filter RecordList
if (rlFilter <> 0)

	*	Duplicate it (for saving purposes)
	rlFilter := rlNewDup(rlFilter)
endif

*	Return with all the info as "fields" in a character string
return l2bin(SAVEFILTVAL) + l2bin(recno()) + l2bin(rlFilter) + dbFilter()


*	isValid()
*
*	action:	Performs a quick check to make certain that we're restoring
*			a valid RecordList.
*
*	input:	saveFilt:	Saved filter.
*
*	return:	.t.:	Is valid
*			.f.:	Is NOT valid
*
*	alters:	None.

static function isValid(saveFilt)
local retVal := .f.

*	If it's a character string and it has the right check value, it's OK
if (valType(saveFilt) == 'C') .and. (bin2l(saveFilt) == SAVEFILTVAL)
	retVal := .t.
endif

*	Return indicating how we did
return retVal


*	cmRestFilter()
*
*	action:	Restores a filter condition which was previously saved by
*			cmSaveFilter().
*
*	input:	saveFilt:	Saved filter.
*
*	return:	None.
*
*	alters:	o	Will change the filter state as reflected by saveFilt

function cmRestFilter(saveFilt)
local recno, rl, filter

*	If it is a valid save filter
if (isValid(saveFilt))

	*	Get the saved info
	recno := bin2l(substr(saveFilt, RECNOOFS, 4))
	rl := bin2l(substr(saveFilt, RLOFS, 4))
	filter := substr(saveFilt, FILTEROFS)

	*	If we've got an actual filter, set it up, otherwise, just clear it
	if (!empty(filter))
		dbSetFilter( &("{||" + filter + "}"), filter)
	else
		dbClearFilter()
	endif

	*	Always set up the RecordList (such as it is)
	rlSetFilter(rl)

	*	And go to the specified record
	goto recno
endif

return


*	cmDestroyFilter()
*
*	action:	Destroys a filter condition which was previously saved by
*			cmSaveFilter() without restoring it.
*
*	input:	saveFilt:	Saved filter.
*
*	return:	None.
*
*	alters:	o	Will destroy the RecordList in saveFilt.

function cmDestroyFilter(saveFilt)
local rl

*	If it is a valid save filter
if (isValid(saveFilt))

	*	Get the RecordList associated with it
	rl := bin2l(substr(saveFilt, RLOFS, 4))

	*	If it's not a NIL RecordList, then destroy it
	if (rl <> 0)
		rlDestroy(rl)
	endif
endif

return
