*	(C)Copyright LodeStone Consortium 1993 - All Rights Reserved
*	Compile with -l -n -v

*	cmReFilter()
*
*	action:	Rapidly isolates records which meet the condition (built on
*			top of the current filter condition).
*
*	input:	cond:	Condition which records need to meet.  (If omitted or
*					an empty string, no action will be taken)
*
*	return:	NIL
*
*	alters:	o	Discards any previous filter.

function cmReFilter(cond)
local filterRlp
local newCond, newCondBlock
local newRlp

*	If we have no current filter set up, just pass the buck to cmFilter()
if (rlGetFilter() == 0)
	return cmFilter(cond)
endif

*	If we've got a non-empty character string for the condition
if (valType(cond) == 'C') .and. (!empty(cond))

	*	Extract the current Filter RecordList (BEFORE calling dbSetFilter()
	*	which would cause the current Filter RecordList to be discarded)
	filterRlp := rlExFilter()

	*	Add this to get the new condition
	newCond = alltrim(dbfilter()) + " .and. " + alltrim(cond)
	newCondBlock = &("{||" + newCond + "}")
	dbSetFilter(newCondBlock, newCond)

	*	Get the RecordList for the new part of the condition
	newRlp = rlNewQuery(cond)

	*	AND the filter recordList with the new RecordList to get the new
	*	result:
	*
	*	Records which meet the old filter condition AND
	*           which meet the new part of the condition
	*
	*	Note that this operation automatically discards newRlp!
	*
	filterRlp = rlAnd(filterRlp, newRlp)

	*	Set the filter to the new rlp
	rlSetFilter(filterRlp)

	*	If we want linear optimization, then do it
	if (cmGetLinear())
		cmDoLinear()
	endif
endif

*	And back to our invoker
return nil
