*	(C)Copyright LodeStone Consortium 1993 - All Rights Reserved
*	Compile with -l -n -v

*	Flag indicating whether or not linear optimization should automatically
*	be used
static _linearOpt := .f.

*	cmSetLinear()
*
*	action:	Sets linear optimization on or off.
*
*	input:	lValue:	.t. means linear optimization will be used, .f. means
*					it will not be used.
*
*	return:	Previous linear optimization setting.
*
*	alters:	_linearOpt

function cmSetLinear(lValue)
local prevValue := _linearOpt
if (valType(lValue) == 'L')
	_linearOpt := lValue
endif
return prevValue


*	cmGetLinear()
*
*	action:	Gets the current setting of linear optimization.
*
*	input:	None.
*
*	return:	Current linear optimization setting.
*
*	alters:	None.

function cmGetLinear()
return _linearOpt


*	cmDoLinear()
*
*	action:	Perform Linear Optimization (clears out all Maybe's from the
*			current RecordList).
*
*	input:	None.
*
*	return:	NIL
*
*	alters:	None.

function cmDoLinear()
local rlFilter := rlGetFilter()
local curRec

*	If we have a filter RecordList, it has a Maybe, and we have a filter
*	condition
if ((rlFilter <> 0) .and. rlHasMaybe(rlFilter) .and. !empty(dbFilter()))

	*	Save the current record
	curRec := recno()

	*	Do the Maybe evaluation to clear off all Maybe's from RecordList
	rlMaybeEval(rlFilter, &("{||" + dbFilter() + "}"))

	*	Restore the current record
	goto curRec
endif

*	And back to our invoker
return nil
