*	(C)Copyright LodeStone Consortium 1993 - All Rights Reserved
*	Compile with -l -n -v

*	cmKeyNo()
*
*	action:	Return the logical key number of the current record using
*			the current master index and filter.
*
*	input:	None.
*
*	return:	o	Logical record number
*
*	alters:	o	Forces Linear Optimization to be done

function cmKeyNo()

*	Force Linear Optimization to be done (no Maybe's allowed)
cmDoLinear()

*	Now just return the key number (.t. as second parameter causes filter
*	RecordList to be used)
return cmxKeyno(nil, .t.)


*	cmKeyCount()
*
*	action:	Return the number of keys in the current master index applying
*			the current filter.
*
*	input:	None.
*
*	return:	o	Logical record count
*
*	alters:	o	Forces Linear Optimization to be done

function cmKeyCount()

*	Force Linear Optimization to be done (no Maybe's allowed)
cmDoLinear()

*	Now just return the key count (.t. as second parameter causes filter
*	RecordList to be used)
return cmxKeyCount(nil, .t.)


*	cmKeySkip()
*
*	action:	Skip the specified number of keys (filtered).
*
*	input:	nCount:	Number of keys to skip.
*
*	return:	NIL
*
*	alters:	o	Current position

function cmKeySkip(nCount)
if (valType(nCount) == 'N')
	skip nCount
endif
return nil


*	cmKeyGoto()
*
*	action:	Goto the n'th key (filtered).
*
*	input:	nKeyno:	Number of the key to go to.
*
*	return:	NIL
*
*	alters:	o	Current position

function cmKeyGoto(nCount)
if (valType(nCount) == 'N')

	*	Go'ing top gets us to the first key
	go top

	*	skip (nCount - 1), because the first key is considered key 1
	skip (nCount - 1)
endif
return nil
