*	(C)Copyright LodeStone Consortium 1993 - All Rights Reserved
*	Compile with -l -n -v

*	cmFilter()
*
*	action:	Rapidly isolates the records which meet the condition.
*
*	input:	cond:	Condition which records need to meet.  (If omitted or
*					an empty string, the current filter will simply be
*					cleared).
*
*	return:	NIL
*
*	alters:	o	Discards any previous filter.

function cmFilter(cond)
local cmRetVal := 0
local condBlock, rlp

*	Clear any previously existing filter
cmClrFilter()

*	If we've got a non-empty character string for the condition
if (valType(cond) == 'C') .and. (!empty(cond))

	*	Get the condition block
	condBlock = &("{||" + cond + "}")

	*	Set the filter to this
	dbSetFilter(condBlock, cond)

	*	Get the rlp for the new query
	rlp = rlNewQuery(cond)

	*	Set the filter rlp to this
	rlSetFilter(rlp)

	*	If we want linear optimization, then do it
	if (cmGetLinear())
		cmDoLinear()
	endif
endif

*	And back to our invoker
return nil


*	cmFiltCount()
*
*	action:	Return the number of records which meet the filter condition.
*
*	input:	None.
*
*	return:	NIL
*
*	alters:	o	Clears the filter

function cmFiltCount()

*	Assume everything until we know better
local retVal := recCount()

*	If we have a filter RecordList
if (rlGetFilter() <> 0)

	*	Force Linear Optimization to be done so our count is fully accurate
	cmDoLinear()

	*	Just count how many matches are in there
	retVal := rlCount(rlGetFilter())
endif

return retVal


*	cmClrFilter()
*
*	action:	Clears any filter currently in effect.
*
*	input:	None.
*
*	return:	NIL
*
*	alters:	o	Clears the filter

function cmClrFilter()
if (used())
	set filter to
endif
return nil
