****
*   cmx.ch
*
*   CMX command extension definitions
*
*   (C)Copyright LodeStone Consortium 1992-93.  All rights reserved.
****

REQUEST DBFCMX

#command INDEX ON <key> TO <(cFile)> [<lUnique: UNIQUE>]                ;
            [FOR <for>]                                                 ;
            [WHILE <while>]                                             ;
            [<lUsecurrent: USECURRENT>]                                 ;
            [<lAdditive: ADDITIVE>]                                     ;
            [EVAL <eval> [ EVERY <nEvery> ]]                            ;
    =>  ordCondSet( <"for">, <{for}>,                                   ;
                     nil,                                               ;
                     <{while}>,                                         ;
                     <{eval}>, <nEvery>,                                ;
                     nil, nil, nil,                                     ;
                     nil, nil,                                          ;
                     0, <.lAdditive.>, <.lUsecurrent.> )                ;
        ;  ordCreate(<(cFile)>, nil, <"key">, <{key}>, [<.lUnique.>])

#command INDEX ON <key> TAG <(cTag)> [<lUnique: UNIQUE>]                ;
            [FOR <for>]                                                 ;
            [WHILE <while>]                                             ;
            [<lUsecurrent: USECURRENT>]                                 ;
            [<lAdditive: ADDITIVE>]                                     ;
            [EVAL <eval> [ EVERY <nEvery> ]]                            ;
    =>  ordCondSet( <"for">, <{for}>,                                   ;
                     nil,                                               ;
                     <{while}>,                                         ;
                     <{eval}>, <nEvery>,                                ;
                     nil, nil, nil,                                     ;
                     nil, nil,                                          ;
                     1, <.lAdditive.>, <.lUsecurrent.> )                ;
        ;  ordCreate(nil, <(cTag)>, <"key">, <{key}>, [<.lUnique.>])

    //  Scoping commands

#command SET SCOPE TO                                                   ;
    =>  cmxSetScope(0)                                                  ;
        ; cmxSetScope(1)
        
#command SET SCOPE TO <value>                                           ;
    =>  cmxSetScope(0, <value>)                                         ;
        ; cmxSetScope(1, <value>)

#xcommand SET SCOPETOP TO                                               ;
    =>  cmxSetScope(0)

#xcommand SET SCOPETOP TO <value>                                       ;
    =>  cmxSetScope(0, <value>)

#xcommand SET SCOPEBOTTOM TO                                            ;
    =>  cmxSetScope(1)

#xcommand SET SCOPEBOTTOM TO <value>                                    ;
    =>  cmxSetScope(1, <value>)
