****
*   cmx.ch
*
*   CMX command extension definitions
*
*   (C)Copyright LodeStone Consortium 1992-93.  All rights reserved.
****

extern _VDBFCMX

*   Uncomment out the next line if you want 1.00.09 and earlier support
*   #include "cmxObs.ch"

#command SET ORDER TO                                                   ;
    =>  ordSetFocus( 0 )

#command SET ORDER TO TAG <(cTag)>                                      ;
    =>  ordSetFocus( <(cTag)> )

#command SET INDEX TO <(cIndex1)> [, <(cIndexn)>] ADDITIVE              ;
    =>  dbSetIndex( <(cIndex1)> )                                       ;
        [; dbSetIndex( <(cIndexn)> )]

#command INDEX ON <key> TO <(cFile)> [<lUnique: UNIQUE>]                ;
            [FOR <for>]                                                 ;
            [WHILE <while>]                                             ;
            [<lUsecurrent: USECURRENT>]                                 ;
            [<lAdditive: ADDITIVE>]                                     ;
            [EVAL <eval> [ EVERY <nEvery> ]]                            ;
    =>  ordCondSet( <"for">, <{for}>,                                   ;
                     nil,                                               ;
                     <{while}>,                                         ;
                     <{eval}>, <nEvery>,                                ;
                     nil, nil, nil,                                     ;
                     nil, nil,                                          ;
                     0, <.lAdditive.>, <.lUsecurrent.> )                ;
        ; dbCreateIndex(<(cFile)>, <"key">, <{key}>, <.lUnique.>)

#command INDEX ON <key> TAG <(cTag)> [<lUnique: UNIQUE>]                ;
            [FOR <for>]                                                 ;
            [WHILE <while>]                                             ;
            [<lUsecurrent: USECURRENT>]                                 ;
            [<lAdditive: ADDITIVE>]                                     ;
            [EVAL <eval> [ EVERY <nEvery> ]]                            ;
    =>  ordCondSet( <"for">, <{for}>,                                   ;
                     nil,                                               ;
                     <{while}>,                                         ;
                     <{eval}>, <nEvery>,                                ;
                     nil, nil, nil,                                     ;
                     nil, nil,                                          ;
                     1, <.lAdditive.>, <.lUsecurrent.> )                ;
        ; dbCreateIndex(<(cTag)>, <"key">, <{key}>, <.lUnique.>)

#command REINDEX [EVAL <eval> [ EVERY <nEvery> ]]                       ;
    =>  ordCondSet(nil, nil, nil, nil, <{eval}>, <nEvery>)              ;
        ; dbReIndex()

#command DELETE TAG <(cTag1)> [, <(cTagn)> ]                            ;
    =>  ordDestroy( <(cTag1)> )                                         ;
        [ ; ordDestroy( <(cTagn)> ) ]

    //  Scoping commands

#command SET SCOPE TO                                                   ;
    =>  cmxSetScope(0)                                                  ;
        ; cmxSetScope(1)
        
#command SET SCOPE TO <value>                                           ;
    =>  cmxSetScope(0, <value>)                                         ;
        ; cmxSetScope(1, <value>)

#xcommand SET SCOPETOP TO                                               ;
    =>  cmxSetScope(0)

#xcommand SET SCOPETOP TO <value>                                       ;
    =>  cmxSetScope(0, <value>)

#xcommand SET SCOPEBOTTOM TO                                            ;
    =>  cmxSetScope(1)

#xcommand SET SCOPEBOTTOM TO <value>                                    ;
    =>  cmxSetScope(1, <value>)
