/*
    csyscala.prg - Class(y) ScalarClass and ScalarObject class definitions

    Copyright (c) 1992 Anton van Straaten

    Class(y) 2.0 treats standard Clipper data types as though they belong
    to one of the classes Array, Character, Numeric, Logical, Date, Block,
    or Nil.  With the exception of Array, these classes are subclasses of
    the class ScalarObject, defined here.  ScalarObject overrides the
    Object messages 'copy' and 'deepCopy' so that these messages behave
    correctly when sent to scalar objects.  This is essential to the
    correct operation of Object's 'deepCopy' method, which expects all
    values to be able to respond to the 'copy' message.

    The ScalarObject class is an instance of the metaclass ScalarClass.
    Although these two classes could have been defined in the same class
    declaration block, by declaring 'isScalar' a CLASS METHOD of the
    ScalarObject class, doing it this way provides a more explicit picture
    of the relationship between classes and their metaclasses.

    The clause "METACLASS Class" in the creation of ScalarClass is not
    absolutely necessary, but is more efficient since it tells Class(y)
    that it does not have to create a (provisional) metaclass while
    creating this class.
*/

#include "csylite.ch"


CREATE CLASS ScalarClass FROM Class METACLASS Class
EXPORT:
    METHOD isScalar

END CLASS


METHOD FUNCTION isScalar
RETURN .T.


// explicit "FROM Object" required by csylite.ch
CREATE CLASS ScalarObject FROM Object METACLASS ScalarClass
EXPORT:
    MESSAGE become      METHOD becomeErr    // a scalar cannot "become" another object
    METHOD  copy
    MESSAGE deepCopy    METHOD copy

END CLASS


/*
    copy()

    This handles all scalar classes except Array.
    Array is not inherited from the ScalarObject class.
*/

METHOD FUNCTION copy
RETURN self


#include "csyerror.ch"

METHOD PROCEDURE becomeErr
    ::error(CSYERR_BECOME, "Message 'become' illegally sent to scalar", ::className)
RETURN


// eof csyscala.prg
