/*
    csylite.ch

    Wed  04-01-1992  20:27:22   avs

    This is only used during the Class(y) initialization process.
    There is no advantage in trying to use this file in other situations.
*/

#xcommand   CREATE CLASS <className> [FROM <superClass>] [METACLASS <metaClass>] [FUNCTION <funcName>] ;
                =>                                          ;
                function CSY_OPT([<funcName>,] <className>) ;;
                static self                                 ;;
                local cName, oSuperClass, nVar              ;;
                local nScope, aMethods, aVariables          ;;
                if self == NIL                              ;;
                    cName := <(className)>                  ;;
                    nVar := 0; nScope := CSY_HIDDEN         ;;
                    [oSuperClass := <superClass>();]        ;
                    aMethods := {}; aVariables := {}        ;;
                    self := CSY_OPT([<metaClass>,] Class)():basicNew()

#command    END CLASS   ;
                =>      ;
                self:initPrimCls( cName, aVariables, aMethods, oSuperClass ) ;;
                self:fixPrimClass() ;;
                self:initClass()    ;;
                end; return self

#define     CSY_EXPORTED            1
#define     CSY_PROTECTED           2
#define     CSY_HIDDEN              4

#command    EXPORTED:   =>  nScope := CSY_EXPORTED
#command    VISIBLE:    =>  nScope := CSY_EXPORTED
#command    HIDDEN:     =>  nScope := CSY_HIDDEN
#command    PROTECTED:  =>  nScope := CSY_PROTECTED

// internal translations used by other commands

#xtranslate CSY_OPT(<a>,<b>)        =>  <a>
#xtranslate CSY_OPT(<a>)            =>  <a>

#xtranslate CSY_VARSCOPE( <ro> )    =>  nScope, if( <ro>, nScope * 2, nScope )

#command    VAR <(name1)> [<ro: RO, READONLY>]  ;
                =>                              ;
                AADD( aVariables, { <(name1)>, nil, nil, .t., CSY_VARSCOPE( <.ro.> ), ++nVar, nil, nil } )

#command    METHOD <method1> [, <methodN>]  ;
                =>                          ;
                AADD( aMethods, { <(method1)>, nil, nil, .f., nScope, { || <method1>() } } ) ;;
              [ AADD( aMethods, { <(methodN)>, nil, nil, .f., nScope, { || <methodN>() } } ) ]

#command    MESSAGE <message> METHOD <method>   ;
                =>                              ;
                AADD( aMethods, { <(message)>, nil, nil, .f., nScope, { || <method>() } } )


#translate  ::  =>  self:


#command    METHOD PROCEDURE <name>             ;
                =>                              ;
                static procedure <name>         ;;
                local self := qself()

#command    METHOD FUNCTION <name>              ;
                =>                              ;
                static function <name>          ;;
                local self := qself()


// eof csylite.ch
