/*
    csyerror.ch

    Class(y) error message codes
*/

#define CSYERR_NONOBJECT        10      // "Message sent to non-object"
#define CSYERR_NOTFOUND         20      // "Message not found"
#define CSYERR_BADMETHOD        32      // "Bad or missing method reference"
#define CSYERR_HIDDEN           41      // "Scope violation (hidden)"
#define CSYERR_PROTECTED        42      // "Scope violation (protected)"
#define CSYERR_READONLY         43      // "Scope violation (read only)"
#define CSYERR_WRONGCLASS       44      //
#define CSYERR_BADPERFORM       50      // "PERFORM of bad message - class"
#define CSYERR_DEFERRED         60      // s/b implemented by subclass
#define CSYERR_NOTAVAR          71      // "Not a variable" (delegation)
#define CSYERR_BECOME           81      // "Message 'become' illegally sent to scalar"
#define CSYERR_REINIT           91      // "Classes cannot be reinitialized"


// eof csyerror.ch
