/*
    TstDeleg.PRG

    A simple demonstration of delegation, with communication taking
    place in both directions.  The 'Boss' class delegates the 'doJob'
    message to the subordinate object stored in its 'subord' variable.
    The subordinate object, in this case an instance of the 'Underling'
    class, "talks back" to the Boss object via the 'availTime' message,
    which the Underling class delegates "TO SENDER".

    An alternative means of communicating back to the delegating object is
    also shown: sending a message to the SENDER() function.  This allows
    communication with the delegator without necessarily defining messages
    in the receiving class.

    Since there are two classes in a single module here, the names of the
    'init' method for each class have been qualified so as not to conflict.
*/

#include "class(y).ch"

PROCEDURE Main
    LOCAL b := Boss():new()

    b:doJob()
RETURN


CREATE CLASS Boss
    VAR subord
EXPORT:
    MESSAGE init    METHOD bossInit
    MESSAGE doJob   TO subord
    METHOD availTime
END CLASS


METHOD bossInit
    // initialize the subordinate object
    ::subord := Underling():new( 42 )
RETURN self

METHOD availTime
RETURN -1   // never enough time!


CREATE CLASS Underling
    VAR x
    MESSAGE init METHOD underInit
    MESSAGE availTime TO SENDER
EXPORT:
    METHOD doJob
END CLASS

METHOD underInit( x )
    ::x := x
RETURN self

METHOD doJob()
    IF ::availTime < 0
        // ask the boss again, a different way this time:
        IF SENDER():availTime < 0
            ? "Boss wants it yesterday; underling gives up"
        END
    END
RETURN self

// eof tstdeleg.prg
