/*
    testtabl.prg

    Test the Table and Record classes.

    Thu  02-27-1992  11:40:10   avs
*/

MEMVAR getlist


PROCEDURE Main
    LOCAL i
    LOCAL oCustTable := Table():new( "CUSTOMER" )   // open file and create table object
    LOCAL oCustRec   := oCustTable:new()            // create record object from current record

    CLEAR

    // the following is a data-driven read
    FOR i := 1 TO oCustTable:numFields
        // oCustRec[i+1] below accesses the instance variable corresponding
        // to the i-th field.  See RECORD.PRG for more information.
        @ 5 + i, 10 SAY PADR(oCustTable:fieldName(i), 10) GET oCustRec[i+1]
    NEXT i

    READ

    oCustRec:write()

    oCustTable:skip()

    /*
        having moved the table's cursor to a new record above, we
        reuse the same record object by sending it the :read() message.
        If we wanted a new object, we could just execute oCustTable:new()
        again.  This allows us to create arrays of record objects in
        memory, for example.
    */

    oCustRec:read()

    // a hard-coded read, using instance variable
    // names which correspond to field names
    CLEAR
    @ 5, 0 SAY 'Number  ' GET oCustRec:custNmbr
    @ 6, 0 SAY 'Company ' GET oCustRec:company
    READ

    oCustRec:write()
RETURN


// eof testtabl.prg
