/*
    stack.prg

    Copyright (c) 1991 Anton van Straaten

    06/02/1991 04:18 avs - creation

    A simple implementation of a stack class.
*/

#include "class(y).ch"


CREATE CLASS Stack
    VAR items

EXPORT:
    METHOD  init
    METHOD  push
    METHOD  pop
END CLASS


/*
    init()

    A new stack object can be created from a single value,
    an array of values, or another stack object.  If such
    flexibility is really required, it may be better to use
    a different initializer method for each type.
*/

METHOD init( aItems ), ()
    LOCAL itemType := VALTYPE( aItems )

    IF aItems == NIL
        ::items := {}                       // empty stack
    ELSEIF itemType == 'A'
        ::items := aItems
    ELSEIF itemType == 'O' .AND. aItems:class == Stack()
        ::items := ARRAY( LEN( aItems:items ) )
        ACOPY( aItems:items, ::items )
    ELSE
        ::items := { aItems }
    END
RETURN self


METHOD push( item )
    AADD(::items, item)
RETURN item


METHOD pop
    LOCAL retval
    LOCAL nLen := LEN( ::items )

    IF nLen > 0
        retval := ::items[ nLen ]
        ASIZE( ::items, nLen - 1 )
    END
RETURN retval


// eof stack.prg
