// scrnrect.prg

#include "class(y).ch"
#include "box.ch"


CREATE CLASS ScreenRect FROM Rectangle
    VAR screenBuf
    VAR boxStyle
    VAR color

EXPORT:
    METHOD init
    METHOD moveUp, moveDown
    METHOD moveLeft, moveRight
    METHOD hide, show
END CLASS


METHOD init( top, left, bottom, right, color, boxStyle ), ;
            ( top, left, bottom, right )

    ::boxStyle := IF( boxStyle == NIL, B_DOUBLE, boxStyle )
    ::color := color
    ::show()
RETURN self


METHOD hide
    RestScreen( ::top, ::left, ::bottom, ::right, ::screenBuf )
RETURN self


METHOD show
    LOCAL oldColor := SetColor( ::color )

    ::screenBuf := SaveScreen( ::top, ::left, ::bottom, ::right )
    @ ::top, ::left, ::bottom, ::right BOX ::boxStyle
    SetColor( oldColor )
RETURN self


METHOD moveUp( n )
    ::hide()
    ::set( ::top - n, NIL, ::bottom - n, NIL )
    ::show()
RETURN self


METHOD moveDown( n )
    ::hide()
    ::set( ::top + n, NIL, ::bottom + n, NIL )
    ::show()
RETURN self


METHOD moveLeft( n )
    ::hide()
    ::set( NIL, ::left - n, NIL, ::right - n )
    ::show()
RETURN self


METHOD moveRight( n )
    ::hide()
    ::set( NIL, ::left + n, NIL, ::right + n )
    ::show()
RETURN self


// eof scrnrect.prg
