// rectangle.prg

#include "class(y).ch"


CREATE CLASS Rectangle
EXPORT:
    VAR     top, left       READONLY
    VAR     bottom, right   READONLY

    METHOD  init
    METHOD  set
    METHOD  width, height
    METHOD  area
END CLASS


METHOD init( top, left, bottom, right ), ()
    self:set( top, left, bottom, right )
RETURN self


METHOD set( top, left, bottom, right )
    IF top <> NIL
        self:top := top
    END
    IF left <> NIL
        self:left := left
    END
    IF bottom <> NIL
        self:bottom := bottom
    END
    IF right <> NIL
        self:right := right
    END
RETURN self


METHOD width
RETURN self:right - self:left + 1


METHOD height
RETURN self:bottom - self:top + 1


METHOD area
RETURN self:width * self:height


// eof rectangle.prg
