/*
    winMsg.prg

    Copyright (c) 1991 Anton van Straaten

    Authors: Jose Dias and AvS
    Converted from Summer '87

    Displays a message in an automatically-sized window and returns the
    window handle.  Message can contain \n for newlines.
*/

#include "csywin.ch"


FUNCTION winMsg( msg, Border, BordAtt, IntAtt )
    LOCAL Pos, Pos1, TotLines, LineLen, Line, BotHght, TopHght, Width
    LOCAL i, row, col
    LOCAL lines := {}
    LOCAL win

    IF AT( "\n", msg ) <> 0                     // split lines?
        Pos := 1
        TotLines := LineLen := 0

        WHILE Pos > 0
           Pos1 := AT( "\n", SUBSTR( msg, Pos ) )   // extract "\n"
           IF Pos1 == 0
              Line := SUBSTR( msg, Pos )            // last line in string
              Pos := 0
           ELSE
              Line := SUBSTR( msg, Pos, Pos1 - 1 )
              Pos += Pos1 + 1                       // + 1 skips "\n"
           END

           IF LEN( Line ) > LineLen             // get longest line length
              LineLen := LEN( Line ) + 3
           END

           AADD( lines, Line )                  // add lines to array
           ++TotLines
        END
    ELSE                                        // no split lines
        AADD( Lines, msg )
        LineLen  := LEN( msg ) + 3
        TotLines := 1
    END

    Width   := INT( LineLen / 2 ) + 1           // work out height/width
    BotHght := INT( TotLines / 2 )
    TopHght := TotLines - BotHght
*   Alternative box style:                            "ķӺ "
    win := Window():new( 12 - TopHght, 40 - Width, 13 + BotHght, 40 + Width, ;
                    IF( Border == NIL, "͸Գ ", Border ), BordAtt, IntAtt )
    row := col := 0
    FOR i = 1 TO TotLines
        @ i - 1, 1 SAY Lines[i]
        IF !EMPTY( Lines[i] )
            row := ROW()
            col := COL()
        END
    NEXT

    // tbd: need window method for below
    SetPos(win:top + row, win:left + col)

RETURN win


// eof winmsg.prg
