/*
    win.prg

    Copyright (c) 1991, 1992 Anton van Straaten

    Fri  10-16-1992  23:05:21 avs - updated
*/


#include "class(y).ch"
#include "csywin.ch"
#include "csygen.ch"


STATIC currWin


CREATE CLASS Window
    VAR     buf
    VAR     cursor

    CLASS VAR winList
    MESSAGE winList TO CLASS    // since winList is used so often

    METHOD  close
    METHOD  open

EXPORT:
    VAR     top, left, bottom, right READONLY
    VAR     margin      READONLY

    VAR     boxChars    READONLY
    VAR     frameColor  READONLY
    VAR     paneColor   READONLY
    VAR     isOpen      READONLY

    METHOD  init

    METHOD  width       // make these instvars?
    METHOD  height

    METHOD  show
    METHOD  draw
    METHOD  clear
    METHOD  hide
    METHOD  hideOn
    METHOD  kill
    METHOD  killOn

    METHOD  activate

    METHOD  title

    CLASS METHOD initClass
    CLASS METHOD hideAll

END CLASS


METHOD initClass
    ::winList := List():new()
RETURN self


METHOD init( nTop, nLeft, nBottom, nRight, ;
                cFrame, cFrameColor, cPaneColor, lOpen ), ()
    ::top    := nTop
    ::left   := nLeft
    ::bottom := nBottom
    ::right  := nRight
    ::cursor := Cursor():new()

    ::boxChars   := IfNil( cFrame, DUBLBORD )
    ::frameColor := cFrameColor
    ::paneColor  := cPaneColor

    IF lOpen == NIL .OR. lOpen
        ::show()
    END
RETURN self


METHOD PROCEDURE show
    IF ::isOpen == NIL .OR. !::isOpen
        IF ::winList:tail() <> NIL
            ::winList:tail():cursor:update()
        END
        ::open()
        ::winList:add( self )
    ELSE
        ::activate()
    END
RETURN


METHOD PROCEDURE open
    LOCAL buf := SaveScreen( ::top, ::left, ::bottom, ::right )
    winCurrent(self)
    IF ::isOpen == NIL
        ::draw()
    ELSE
        RestScreen( ::top, ::left, ::bottom, ::right, ::buf )
        ::cursor:show()
    END
    ::buf := buf
    ::isOpen := .t.
RETURN


METHOD PROCEDURE draw
    ::margin := 0
    IF ::boxChars <> NOBORDER
        SetColor( ::frameColor )
        // margin must be 0 for following to work
        @ 0, 0, MAXROW(), MAXCOL() BOX ::boxChars
        ::margin := 1
    END
    ::clear()
RETURN


METHOD PROCEDURE clear
    SetColor(::paneColor)
    @ 0, 0 CLEAR TO MAXROW(), MAXCOL()
    ::cursor:update()
RETURN


METHOD hideOn( event )
    LOCAL key
    LOCAL eventType := VALTYPE( event )
    ::cursor:show()

    IF eventType == 'C'
        // event should contain a string of key values
        WHILE !( CHR( key := INKEY( 0 ) ) $ event )
        END
    ELSEIF eventType $ 'NU'
        // event should contain a number of seconds;
        // 0 waits indefinitely for keystroke
        key := INKEY(event)
    END
    ::hide()
RETURN key


METHOD hide
    IF ::isOpen <> NIL .AND. ::isOpen
        IF !( self == ::winList:tail() )
            ::activate()    // tbd: flag to prevent open of window being deleted? or use procname() in activate
        END
        ::close()
        ::winList:delete()
        IF ::winList:tail() <> NIL
            ::winList:tail():activate()
        END
    END
RETURN self


METHOD PROCEDURE close
    LOCAL buf := SaveScreen(::top, ::left, ::bottom, ::right)

    RestScreen(::top, ::left, ::bottom, ::right, ::buf)
    ::cursor:hide()
    ::buf    := buf
    ::isOpen := .f.
RETURN


METHOD PROCEDURE kill
    ::hide()
    ::buf := NIL
    ::cursor := NIL
RETURN


METHOD FUNCTION killOn(event)
    LOCAL key := ::hideOn(event)
    ::kill()
RETURN key


METHOD PROCEDURE activate
    LOCAL win := ::winList:tail()

    IF !( win == self ) .AND. win <> NIL
        // close all windows down to self
        WHILE win <> NIL
            win:close()
            IF win == self
                EXIT
            END
            win := ::winList:prev()
        END

        ::winList:delete()              // delete self from list
        win := ::winList:current()

        WHILE win <> NIL
            win:open()
            win := ::winList:next()
        END
        ::winList:add(self)
        ::open()
    ELSEIF win <> NIL
        ::cursor:show()
        winCurrent(self)
    END
RETURN


METHOD width
RETURN (::right - ::left - ::margin * 2 + 1)


METHOD height
RETURN (::bottom - ::top - ::margin * 2 + 1)


METHOD hideAll
    LOCAL win

    WHILE (win := ::winList:tail()) <> NIL
        win:hide()
    END
RETURN self


/*

    :title(cMsg, nPosn, cColor)

    Display msg on the window border in position specified by posn, which
    must be one of the constants specified in winInit(): wTL, wTC, wTR, wBL,
    wBC, or wBR.  If msg is numeric, the relevant portion of the border is
    redrawn.  The color parameter is optional.
*/

METHOD PROCEDURE title( msg, posn, color )
    LOCAL row, col, horizline

    IF ::isOpen == NIL .OR. !::isOpen        // tbd: method for this?
        RETURN
    END

    ::activate()
    DEFAULT posn TO wTC
    IF posn == wTL .OR. posn == wTC .OR. posn == wTR
        row := ::top
        horizline := SUBSTR( ::boxChars, 2, 1 )
    ELSEIF posn == wBL .OR. posn == wBC .OR. posn == wBR
        row := ::bottom
        horizline := SUBSTR( ::boxChars, 6, 1 )
//  ELSE
//      tbd: error (or other behavior?)
    END

    IF VALTYPE( msg ) = 'N'
        msg = REPLICATE( horizline, msg )
    END

    DO CASE
        CASE posn == wTL .OR. posn == wBL
            col := ::left + 2
        CASE posn == wTC .OR. posn == wBC
            col := ( ::right + ::left - LEN( msg ) ) / 2
        CASE posn == wTR .OR. posn == wBR
            col := ::right - LEN( msg ) - 2
    END

    IF col + len(msg) > ::right
        msg := LEFT( msg, ::right - col )   // truncate message
    END

    ::cursor:update()
    SetColor( IF( color == NIL, ::frameColor, color ) )
    // to avoid translation:
    DevPos(row, col)
    DevOut(msg)
    ::cursor:show()
RETURN


FUNCTION winCurrent(w)
    IF w != NIL
        IF valtype(w) == 'N' .and. w == 0
            // this is the only way to select the main screen at present. tbd.
            CurrWin := NIL
        ELSE
            CurrWin := w
        END
    END
RETURN CurrWin


FUNCTION winTop
RETURN IF( CurrWin == NIL, 0, CurrWin:top + CurrWin:margin )

FUNCTION winLeft
RETURN IF( CurrWin == NIL, 0, CurrWin:left + CurrWin:margin )

FUNCTION winMaxRow
// 24 below is very naughty
RETURN IF( CurrWin == NIL, 24, CurrWin:height() - 1 )

FUNCTION winMaxCol
// 79 below is very naughty
RETURN IF( CurrWin == NIL, 79, CurrWin:width() - 1 )


// used in win.ch
FUNCTION _wintrunc(str, nCol)
RETURN LEFT( str, if(CurrWin == NIL, 79, CurrWin:width() - nCol) )


// eof win.prg
